/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.workspace;

import com.perforce.p4java.client.IClient;
import com.perforce.p4java.client.IClientSummary;
import com.perforce.p4java.core.IStream;
import com.perforce.p4java.core.IStreamSummary;
import com.perforce.p4java.option.server.GetClientsOptions;
import com.perforce.p4java.option.server.GetStreamsOptions;
import com.perforce.p4java.server.IOptionsServer;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.ArrayList;
import java.util.List;
import org.jenkinsci.plugins.p4.client.ConnectionFactory;
import org.jenkinsci.plugins.p4.workspace.Workspace;
import org.kohsuke.stapler.QueryParameter;

public abstract class WorkspaceDescriptor
extends Descriptor<Workspace> {
    public WorkspaceDescriptor(Class<? extends Workspace> clazz) {
        super(clazz);
    }

    protected WorkspaceDescriptor() {
    }

    public static FormValidation checkClientName(String value) {
        try {
            IOptionsServer p4 = ConnectionFactory.getConnection();
            if (p4 == null) {
                return FormValidation.ok();
            }
            IClient client = p4.getClient(value);
            if (client != null) {
                return FormValidation.ok();
            }
            return FormValidation.warning((String)("Unknown Client: " + value));
        }
        catch (Exception e) {
            return FormValidation.error((String)e.getMessage());
        }
    }

    public static AutoCompletionCandidates autoCompleteName(@QueryParameter String value) {
        AutoCompletionCandidates c = new AutoCompletionCandidates();
        try {
            IOptionsServer iserver = ConnectionFactory.getConnection();
            if (iserver != null && value.length() > 0) {
                String user = iserver.getUserName();
                List list = iserver.getClients(user, value + "*", 10);
                for (IClientSummary l : list) {
                    c.add(l.getName());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return c;
    }

    public static ListBoxModel doFillCharsetItems() {
        ListBoxModel list = new ListBoxModel();
        try {
            IOptionsServer p4 = ConnectionFactory.getConnection();
            for (String set : p4.getKnownCharsets()) {
                list.add(set);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (list.isEmpty()) {
            list.add("none");
        }
        return list;
    }

    public static AutoCompletionCandidates doAutoCompleteStreamName(@QueryParameter String value) {
        AutoCompletionCandidates c = new AutoCompletionCandidates();
        try {
            IOptionsServer iserver = ConnectionFactory.getConnection();
            if (iserver != null && value.length() > 1) {
                ArrayList<String> streamPaths = new ArrayList<String>();
                streamPaths.add(value + "...");
                GetStreamsOptions opts = new GetStreamsOptions();
                opts.setMaxResults(10);
                List list = iserver.getStreams(streamPaths, opts);
                for (IStreamSummary l : list) {
                    c.add(l.getStream());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return c;
    }

    public static AutoCompletionCandidates doAutoCompleteTemplateName(@QueryParameter String value) {
        AutoCompletionCandidates c = new AutoCompletionCandidates();
        try {
            IOptionsServer iserver = ConnectionFactory.getConnection();
            if (iserver != null && value.length() > 0) {
                GetClientsOptions opts = new GetClientsOptions();
                opts.setMaxResults(10);
                opts.setNameFilter(value + "*");
                List list = iserver.getClients(opts);
                for (IClientSummary l : list) {
                    c.add(l.getName());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return c;
    }

    public static FormValidation doCheckStreamName(@QueryParameter String value) {
        try {
            IOptionsServer p4 = ConnectionFactory.getConnection();
            IStream stream = p4.getStream(value);
            if (stream != null) {
                return FormValidation.ok();
            }
            return FormValidation.warning((String)("Unknown Stream: " + value));
        }
        catch (Exception e) {
            return FormValidation.error((String)e.getMessage());
        }
    }

    public static FormValidation doCheckFormat(@QueryParameter String value) {
        if (value == null || value.isEmpty()) {
            return FormValidation.error((String)"Workspace Name format is mandatory.");
        }
        if (value.contains("${") && value.contains("}")) {
            return FormValidation.ok();
        }
        return FormValidation.error((String)"Workspace Name format error.");
    }
}

