/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.workspace;

import com.perforce.p4java.client.IClient;
import com.perforce.p4java.server.IOptionsServer;
import hudson.DescriptorExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Describable;
import java.util.Map;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.p4.workspace.Expand;
import org.jenkinsci.plugins.p4.workspace.WorkspaceDescriptor;
import org.jenkinsci.plugins.p4.workspace.WorkspaceType;

public abstract class Workspace
implements Cloneable,
ExtensionPoint,
Describable<Workspace> {
    private String charset;
    private boolean pinHost;
    private String rootPath;
    private String hostname;
    private Expand expand;

    public Workspace(String charset, boolean pinHost) {
        this.charset = charset;
        this.pinHost = pinHost;
    }

    public abstract WorkspaceType getType();

    public abstract String getName();

    public String getCharset() {
        return this.charset;
    }

    public boolean isPinHost() {
        return this.pinHost;
    }

    public abstract IClient setClient(IOptionsServer var1, String var2) throws Exception;

    public WorkspaceDescriptor getDescriptor() {
        return (WorkspaceDescriptor)Jenkins.getInstance().getDescriptor(this.getClass());
    }

    public static DescriptorExtensionList<Workspace, WorkspaceDescriptor> all() {
        return Jenkins.getInstance().getDescriptorList(Workspace.class);
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public void setHostName(String hostname) {
        this.hostname = hostname;
    }

    public String getHostName() {
        return this.hostname;
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public void setExpand(Map<String, String> map) {
        this.expand = new Expand(map);
    }

    public Expand getExpand() {
        return this.expand;
    }

    public String getFullName() {
        String clientName = this.expand.format(this.getName(), false);
        clientName = clientName.replaceAll(" ", "_");
        clientName = clientName.replaceAll(",", "-");
        clientName = clientName.replaceAll("=", "-");
        clientName = clientName.replaceAll("/", "-");
        this.expand.set("P4_CLIENT", clientName);
        return clientName;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

