/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.workspace;

import com.perforce.p4java.client.IClient;
import com.perforce.p4java.impl.mapbased.client.Client;
import com.perforce.p4java.option.server.SwitchClientViewOptions;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.IServer;
import hudson.Extension;
import hudson.util.FormValidation;
import java.util.logging.Logger;
import org.jenkinsci.plugins.p4.workspace.Expand;
import org.jenkinsci.plugins.p4.workspace.Workspace;
import org.jenkinsci.plugins.p4.workspace.WorkspaceDescriptor;
import org.jenkinsci.plugins.p4.workspace.WorkspaceType;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class TemplateWorkspaceImpl
extends Workspace {
    private final String templateName;
    private final String format;
    private static Logger logger = Logger.getLogger(TemplateWorkspaceImpl.class.getName());

    public String getTemplateName() {
        return this.templateName;
    }

    public String getFormat() {
        return this.format;
    }

    @Override
    public String getName() {
        return this.format;
    }

    @Override
    public WorkspaceType getType() {
        return WorkspaceType.TEMPLATED;
    }

    @DataBoundConstructor
    public TemplateWorkspaceImpl(String charset, boolean pinHost, String templateName, String format) {
        super(charset, pinHost);
        this.templateName = templateName;
        this.format = format;
    }

    @Override
    public IClient setClient(IOptionsServer connection, String user) throws Exception {
        Expand expand = this.getExpand();
        String template = expand.format(this.getTemplateName(), false);
        IClient itemplate = connection.getClient(template);
        if (itemplate == null) {
            return null;
        }
        String clientName = this.getFullName();
        IClient iclient = connection.getClient(clientName);
        if (iclient == null) {
            logger.info("P4: Creating template client: " + clientName);
            Client implClient = new Client((IServer)connection);
            implClient.setName(clientName);
            implClient.setOwnerName(user);
            connection.createClient((IClient)implClient);
            iclient = connection.getClient(clientName);
        }
        iclient.setOwnerName(user);
        iclient.setLineEnd(itemplate.getLineEnd());
        iclient.setOptions(itemplate.getOptions());
        iclient.setRoot(this.getRootPath());
        iclient.update();
        SwitchClientViewOptions opts = new SwitchClientViewOptions();
        opts.setForce(true);
        connection.switchClientView(template, clientName, opts);
        iclient = connection.getClient(clientName);
        return iclient;
    }

    @Extension
    public static final class DescriptorImpl
    extends WorkspaceDescriptor {
        public static final String defaultFormat = "jenkins-${NODE_NAME}-${JOB_NAME}";

        public String getDisplayName() {
            return "Template (view generated for each node)";
        }

        public FormValidation doCheckTemplateName(@QueryParameter String value) {
            return DescriptorImpl.checkClientName(value);
        }
    }
}

