/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.workspace;

import com.perforce.p4java.core.IStream;
import com.perforce.p4java.core.IStreamSummary;
import com.perforce.p4java.option.server.GetStreamsOptions;
import com.perforce.p4java.server.IOptionsServer;
import hudson.model.AutoCompletionCandidates;
import hudson.util.FormValidation;
import java.util.ArrayList;
import java.util.List;
import org.jenkinsci.plugins.p4.client.ConnectionFactory;
import org.kohsuke.stapler.QueryParameter;

public class StreamDescImpl {
    public static AutoCompletionCandidates doAutoCompleteStreamName(@QueryParameter String value) {
        AutoCompletionCandidates c = new AutoCompletionCandidates();
        try {
            IOptionsServer iserver = ConnectionFactory.getConnection();
            if (iserver != null && value.length() > 1) {
                ArrayList<String> streamPaths = new ArrayList<String>();
                streamPaths.add(value + "...");
                GetStreamsOptions opts = new GetStreamsOptions();
                opts.setMaxResults(10);
                List list = iserver.getStreams(streamPaths, opts);
                for (IStreamSummary l : list) {
                    c.add(l.getStream());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return c;
    }

    public static FormValidation doCheckStreamName(@QueryParameter String value) {
        try {
            IOptionsServer p4 = ConnectionFactory.getConnection();
            IStream stream = p4.getStream(value);
            if (stream != null) {
                return FormValidation.ok();
            }
            return FormValidation.warning((String)("Unknown Stream: " + value));
        }
        catch (Exception e) {
            return FormValidation.error((String)e.getMessage());
        }
    }

    public static FormValidation doCheckFormat(@QueryParameter String value) {
        if (value == null || value.isEmpty()) {
            return FormValidation.error((String)"Workspace Name format is mandatory.");
        }
        if (value.contains("${") && value.contains("}")) {
            return FormValidation.ok();
        }
        return FormValidation.error((String)"Workspace Name format error.");
    }
}

