/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.workspace;

import com.perforce.p4java.client.IClient;
import com.perforce.p4java.core.file.FileSpecBuilder;
import com.perforce.p4java.impl.mapbased.client.Client;
import com.perforce.p4java.option.server.GetFileContentsOptions;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.IServer;
import hudson.Extension;
import hudson.model.AutoCompletionCandidates;
import hudson.util.FormValidation;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.plugins.p4.client.ConnectionFactory;
import org.jenkinsci.plugins.p4.client.NavigateHelper;
import org.jenkinsci.plugins.p4.workspace.Workspace;
import org.jenkinsci.plugins.p4.workspace.WorkspaceDescriptor;
import org.jenkinsci.plugins.p4.workspace.WorkspaceType;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class SpecWorkspaceImpl
extends Workspace {
    private final String name;
    private final String specPath;
    private static Logger logger = Logger.getLogger(SpecWorkspaceImpl.class.getName());

    @Override
    public String getName() {
        return this.name;
    }

    public String getSpecPath() {
        return this.specPath;
    }

    @Override
    public WorkspaceType getType() {
        return WorkspaceType.SPEC;
    }

    @DataBoundConstructor
    public SpecWorkspaceImpl(String charset, boolean pinHost, String name, String specPath) {
        super(charset, pinHost);
        this.name = name;
        this.specPath = specPath;
    }

    @Override
    public IClient setClient(IOptionsServer connection, String user) throws Exception {
        String clientName = this.getFullName();
        IClient iclient = connection.getClient(clientName);
        if (iclient == null) {
            logger.info("P4: Creating client from spec: " + clientName);
            Client implClient = new Client((IServer)connection);
            implClient.setName(clientName);
            implClient.setOwnerName(user);
            connection.createClient((IClient)implClient);
            iclient = connection.getClient(clientName);
        }
        iclient.setOwnerName(user);
        List file = FileSpecBuilder.makeFileSpecList((String)this.specPath);
        GetFileContentsOptions printOpts = new GetFileContentsOptions();
        printOpts.setNoHeaderLine(true);
        InputStream ins = connection.getFileContents(file, printOpts);
        String spec = IOUtils.toString((InputStream)ins, (String)"UTF-8");
        connection.execInputStringMapCmd("client", new String[]{"-i"}, spec);
        iclient.refresh();
        return iclient;
    }

    @Extension
    public static final class DescriptorImpl
    extends WorkspaceDescriptor {
        public String getDisplayName() {
            return "Spec File (load workspace spec from file in Perforce)";
        }

        public AutoCompletionCandidates doAutoCompleteName(@QueryParameter String value) {
            return DescriptorImpl.autoCompleteName(value);
        }

        public FormValidation doCheckName(@QueryParameter String value) {
            return DescriptorImpl.checkClientName(value);
        }

        public AutoCompletionCandidates doAutoCompleteSpecPath(@QueryParameter String value) {
            return NavigateHelper.getPath(value);
        }

        public FormValidation doCheckSpecPath(@QueryParameter String value) {
            try {
                IOptionsServer p4 = ConnectionFactory.getConnection();
                List file = FileSpecBuilder.makeFileSpecList((String)value);
                GetFileContentsOptions printOpts = new GetFileContentsOptions();
                InputStream ins = p4.getFileContents(file, printOpts);
                if (ins != null) {
                    return FormValidation.ok();
                }
                return FormValidation.error((String)("Unknown file: " + value));
            }
            catch (Exception e) {
                return FormValidation.error((String)e.getMessage());
            }
        }
    }
}

