/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.workspace;

import com.perforce.p4java.client.IClient;
import com.perforce.p4java.client.IClientSummary;
import com.perforce.p4java.client.IClientViewMapping;
import com.perforce.p4java.core.IMapEntry;
import com.perforce.p4java.impl.generic.client.ClientOptions;
import com.perforce.p4java.impl.generic.client.ClientView;
import com.perforce.p4java.impl.mapbased.client.Client;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.IServer;
import hudson.AbortException;
import hudson.Extension;
import hudson.model.AutoCompletionCandidates;
import hudson.util.FormValidation;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.p4.client.ConnectionFactory;
import org.jenkinsci.plugins.p4.workspace.Workspace;
import org.jenkinsci.plugins.p4.workspace.WorkspaceDescriptor;
import org.jenkinsci.plugins.p4.workspace.WorkspaceSpec;
import org.jenkinsci.plugins.p4.workspace.WorkspaceType;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class ManualWorkspaceImpl
extends Workspace {
    private final String name;
    public WorkspaceSpec spec;
    private static Logger logger = Logger.getLogger(ManualWorkspaceImpl.class.getName());

    @Override
    public String getName() {
        return this.name;
    }

    public WorkspaceSpec getSpec() {
        return this.spec;
    }

    @Override
    public WorkspaceType getType() {
        return WorkspaceType.MANUAL;
    }

    @DataBoundConstructor
    public ManualWorkspaceImpl(String charset, boolean pinHost, String name, WorkspaceSpec spec) {
        super(charset, pinHost);
        this.name = name;
        this.spec = spec;
    }

    @Override
    public IClient setClient(IOptionsServer connection, String user) throws Exception {
        String clientName = this.getFullName();
        IClient iclient = connection.getClient(clientName);
        if (iclient == null) {
            logger.info("P4: Creating manual client: " + clientName);
            Client implClient = new Client((IServer)connection);
            implClient.setName(clientName);
            implClient.setOwnerName(user);
            connection.createClient((IClient)implClient);
            iclient = connection.getClient(clientName);
        }
        iclient.setOwnerName(user);
        ClientOptions options = new ClientOptions();
        options.setAllWrite(this.getSpec().allwrite);
        options.setClobber(this.getSpec().clobber);
        options.setCompress(this.getSpec().compress);
        options.setLocked(this.getSpec().locked);
        options.setModtime(this.getSpec().modtime);
        options.setRmdir(this.getSpec().rmdir);
        iclient.setOptions((IClientSummary.IClientOptions)options);
        String streamFullName = this.getSpec().getStreamName();
        if (streamFullName != null) {
            streamFullName = this.getExpand().format(streamFullName, false);
        }
        iclient.setStream(streamFullName);
        iclient.setLineEnd(this.parseLineEnd(this.getSpec().getLine()));
        ClientView clientView = new ClientView();
        int order = 0;
        for (String line : this.getSpec().getView().split("\\n")) {
            String origName = this.getName();
            line = line.replace(origName, clientName);
            line = this.getExpand().format(line, false);
            try {
                ClientView.ClientViewMapping entry = new ClientView.ClientViewMapping(order, line);
                ++order;
                clientView.addEntry((IMapEntry)entry);
            }
            catch (Exception e) {
                String msg = "P4: invalid client view: " + line;
                logger.warning(msg);
                throw new AbortException(msg);
            }
        }
        iclient.setClientView(clientView);
        return iclient;
    }

    private IClientSummary.ClientLineEnd parseLineEnd(String line) {
        for (IClientSummary.ClientLineEnd end : IClientSummary.ClientLineEnd.values()) {
            if (!end.name().equalsIgnoreCase(line)) continue;
            return end;
        }
        return IClientSummary.ClientLineEnd.LOCAL;
    }

    @JavaScriptMethod
    public JSONObject getSpecJSON(String client) {
        try {
            IOptionsServer p4 = ConnectionFactory.getConnection();
            IClient c = p4.getClient(client);
            StringBuffer sb = new StringBuffer();
            for (IClientViewMapping view : c.getClientView()) {
                sb.append(view.toString(" ", true));
                sb.append("\n");
            }
            JSONObject option = new JSONObject();
            option.put("allwrite", (Object)c.getOptions().isAllWrite());
            option.put("clobber", (Object)c.getOptions().isClobber());
            option.put("compress", (Object)c.getOptions().isCompress());
            option.put("locked", (Object)c.getOptions().isLocked());
            option.put("modtime", (Object)c.getOptions().isModtime());
            option.put("rmdir", (Object)c.getOptions().isRmdir());
            JSONObject spec = new JSONObject();
            spec.put("stream", (Object)(c.getStream() == null ? "" : c.getStream()));
            spec.put("line", (Object)c.getLineEnd().name());
            spec.put("view", (Object)sb.toString());
            spec.put("options", (Object)option);
            return spec;
        }
        catch (Exception e) {
            JSONObject option = new JSONObject();
            option.put("allwrite", (Object)false);
            option.put("clobber", (Object)true);
            option.put("compress", (Object)false);
            option.put("locked", (Object)false);
            option.put("modtime", (Object)false);
            option.put("rmdir", (Object)false);
            JSONObject spec = new JSONObject();
            spec.put("stream", (Object)"");
            spec.put("line", (Object)"LOCAL");
            spec.put("view", (Object)"please define view...");
            spec.put("options", (Object)option);
            return spec;
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends WorkspaceDescriptor {
        public String getDisplayName() {
            return "Manual (custom view)";
        }

        public AutoCompletionCandidates doAutoCompleteName(@QueryParameter String value) {
            return DescriptorImpl.autoCompleteName(value);
        }

        public FormValidation doCheckName(@QueryParameter String value) {
            return DescriptorImpl.checkClientName(value);
        }
    }
}

