/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.workspace;

import hudson.slaves.EnvironmentVariablesNodeProperty;
import hudson.slaves.NodeProperty;
import java.util.HashMap;
import java.util.Map;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.p4.review.ReviewProp;

public class Expand {
    private Map<String, String> formatTags = new HashMap<String, String>();

    public Expand(Map<String, String> map) {
        Jenkins jenkins = Jenkins.getInstance();
        for (NodeProperty node : jenkins.getGlobalNodeProperties()) {
            if (!(node instanceof EnvironmentVariablesNodeProperty)) continue;
            EnvironmentVariablesNodeProperty env = (EnvironmentVariablesNodeProperty)node;
            this.formatTags.putAll((Map<String, String>)env.getEnvVars());
        }
        for (String key : map.keySet()) {
            String value = map.get(key);
            if (ReviewProp.isProp(key)) {
                key = ReviewProp.NAMESPACE + key;
            }
            this.set(key, value);
        }
    }

    public String format(String format, boolean wildcard) {
        if (this.formatTags != null) {
            for (String tag : this.formatTags.keySet()) {
                String value = this.formatTags.get(tag);
                if (value == null) continue;
                format = format.replace("${" + tag + "}", value);
            }
        }
        if (wildcard) {
            format = format.replaceAll("\\$\\{.+?\\}", "*");
        }
        format = format.replace("${", "");
        format = format.replace("}", "");
        return format;
    }

    public void set(String tag, String value) {
        this.formatTags.put(tag, value);
    }

    public String get(String tag) {
        if (this.formatTags == null) {
            return null;
        }
        return this.formatTags.get(tag);
    }
}

