/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.workflow;

import hudson.Extension;
import hudson.model.AutoCompletionCandidates;
import hudson.scm.SCM;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import org.jenkinsci.plugins.p4.PerforceScm;
import org.jenkinsci.plugins.p4.browsers.P4Browser;
import org.jenkinsci.plugins.p4.credentials.P4CredentialsImpl;
import org.jenkinsci.plugins.p4.populate.AutoCleanImpl;
import org.jenkinsci.plugins.p4.workspace.ManualWorkspaceImpl;
import org.jenkinsci.plugins.p4.workspace.StreamWorkspaceImpl;
import org.jenkinsci.plugins.p4.workspace.TemplateWorkspaceImpl;
import org.jenkinsci.plugins.p4.workspace.Workspace;
import org.jenkinsci.plugins.p4.workspace.WorkspaceDescriptor;
import org.jenkinsci.plugins.p4.workspace.WorkspaceSpec;
import org.jenkinsci.plugins.workflow.steps.scm.SCMStep;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class P4Step
extends SCMStep {
    private static final long serialVersionUID = 1L;
    private final String credential;
    private String stream = "";
    private String depotPath = "";
    private String template = "";
    private String charset = "";
    private String format = "jenkins-${NODE_NAME}-${JOB_NAME}";

    @DataBoundConstructor
    public P4Step(String credential) {
        this.credential = credential;
    }

    public String getStream() {
        return this.stream;
    }

    @DataBoundSetter
    public void setStream(String stream) {
        this.stream = stream;
    }

    public String getDepotPath() {
        return this.depotPath;
    }

    @DataBoundSetter
    public void setDepotPath(String path) {
        this.depotPath = path;
    }

    public String getTemplate() {
        return this.template;
    }

    @DataBoundSetter
    public void setTemplate(String template) {
        this.template = template;
    }

    public String getCharset() {
        return this.charset;
    }

    @DataBoundSetter
    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getFormat() {
        return this.format;
    }

    @DataBoundSetter
    public void setFormat(String format) {
        this.format = format;
    }

    public String getCredential() {
        return this.credential;
    }

    protected SCM createSCM() {
        P4Browser browser = null;
        Workspace workspace = null;
        if (P4Step.notNull(this.stream)) {
            workspace = new StreamWorkspaceImpl(this.charset, false, this.stream, this.format);
        } else if (P4Step.notNull(this.template)) {
            workspace = new TemplateWorkspaceImpl(this.charset, false, this.template, this.format);
        } else if (P4Step.notNull(this.depotPath)) {
            String view = this.depotPath + "/..." + " " + "//" + this.format + "/...";
            WorkspaceSpec spec = new WorkspaceSpec(false, false, false, false, false, false, null, "local", view);
            workspace = new ManualWorkspaceImpl(this.charset, false, this.format, spec);
        }
        AutoCleanImpl populate = new AutoCleanImpl(true, true, false, false, null);
        PerforceScm scm = new PerforceScm(this.credential, workspace, null, populate, browser);
        return scm;
    }

    static boolean notNull(String value) {
        return value != null && !value.isEmpty();
    }

    @Extension(optional=true)
    public static final class DescriptorImpl
    extends SCMStep.SCMStepDescriptor {
        public static final String defaultFormat = "jenkins-${NODE_NAME}-${JOB_NAME}";

        public DescriptorImpl() {
            PerforceScm.class.hashCode();
        }

        public ListBoxModel doFillCredentialItems() {
            return P4CredentialsImpl.doFillCredentialItems();
        }

        public FormValidation doCheckCredential(@QueryParameter String value) {
            return P4CredentialsImpl.doCheckCredential(value);
        }

        public AutoCompletionCandidates doAutoCompleteStream(@QueryParameter String value) {
            return WorkspaceDescriptor.doAutoCompleteStreamName(value);
        }

        public AutoCompletionCandidates doAutoCompleteTemplate(@QueryParameter String value) {
            return WorkspaceDescriptor.doAutoCompleteTemplateName(value);
        }

        private static boolean hasMultiple(String stream, String template, String path) {
            if (P4Step.notNull(stream) && (P4Step.notNull(template) || P4Step.notNull(path))) {
                return true;
            }
            if (P4Step.notNull(template) && (P4Step.notNull(stream) || P4Step.notNull(path))) {
                return true;
            }
            return P4Step.notNull(path) && (P4Step.notNull(template) || P4Step.notNull(stream));
        }

        public FormValidation doCheckStream(@QueryParameter String value, @QueryParameter String template, @QueryParameter String path) {
            if (P4Step.notNull(value)) {
                if (DescriptorImpl.hasMultiple(value, template, path)) {
                    return FormValidation.error((String)"Specify only one source.");
                }
                return WorkspaceDescriptor.doCheckStreamName(value);
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckTemplate(@QueryParameter String value, @QueryParameter String stream, @QueryParameter String path) {
            if (P4Step.notNull(value)) {
                if (DescriptorImpl.hasMultiple(stream, value, path)) {
                    return FormValidation.error((String)"Specify only one source.");
                }
                return WorkspaceDescriptor.checkClientName(value);
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckPath(@QueryParameter String value, @QueryParameter String stream, @QueryParameter String template) {
            if (P4Step.notNull(value)) {
                if (DescriptorImpl.hasMultiple(stream, template, value)) {
                    return FormValidation.error((String)"Specify only one source.");
                }
                return FormValidation.ok();
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillCharsetItems() {
            return WorkspaceDescriptor.doFillCharsetItems();
        }

        public String getFunctionName() {
            return "p4sync";
        }

        public String getDisplayName() {
            return "P4 Sync";
        }
    }
}

