/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.unshelve;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.scm.SCM;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Builder;
import java.io.IOException;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.p4.PerforceScm;
import org.jenkinsci.plugins.p4.tasks.UnshelveTask;
import org.jenkinsci.plugins.p4.workspace.Workspace;
import org.kohsuke.stapler.DataBoundConstructor;

public class UnshelveBuilder
extends Builder {
    private final String shelf;
    private final String resolve;
    private static Logger logger = Logger.getLogger(UnshelveBuilder.class.getName());

    @DataBoundConstructor
    public UnshelveBuilder(String shelf, String resolve) {
        this.shelf = shelf;
        this.resolve = resolve;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public String getShelf() {
        return this.shelf;
    }

    public String getResolve() {
        return this.resolve;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        AbstractProject project = (AbstractProject)build.getParent();
        SCM scm = project.getScm();
        if (scm instanceof PerforceScm) {
            PerforceScm p4 = (PerforceScm)scm;
            String credential = p4.getCredential();
            Workspace workspace = p4.getWorkspace();
            FilePath buildWorkspace = build.getWorkspace();
            try {
                return this.unshelve((Run<?, ?>)build, credential, workspace, buildWorkspace, (TaskListener)listener);
            }
            catch (IOException e) {
                logger.warning("Unable to Unshelve");
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                logger.warning("Unable to Unshelve");
                e.printStackTrace();
            }
        }
        return false;
    }

    protected boolean unshelve(Run<?, ?> run, String credential, Workspace workspace, FilePath buildWorkspace, TaskListener listener) throws IOException, InterruptedException {
        UnshelveTask task = new UnshelveTask(this.resolve);
        task.setListener(listener);
        task.setCredential(credential);
        Workspace ws = task.setEnvironment(run, workspace, buildWorkspace);
        String id = ws.getExpand().format(this.shelf, false);
        int change = Integer.parseInt(id);
        task.setShelf(change);
        task.setWorkspace(ws);
        return (Boolean)buildWorkspace.act((FilePath.FileCallable)task);
    }

    public static DescriptorImpl descriptor() {
        return (DescriptorImpl)Jenkins.getInstance().getDescriptorByType(DescriptorImpl.class);
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Perforce: Unshelve";
        }
    }
}

