/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.trigger;

import hudson.Extension;
import hudson.Util;
import hudson.console.AnnotatedLargeText;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.TaskListener;
import hudson.scm.PollingResult;
import hudson.scm.SCM;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Logger;
import jenkins.triggers.SCMTriggerItem;
import org.apache.commons.jelly.XMLOutput;
import org.jenkinsci.plugins.p4.PerforceScm;
import org.jenkinsci.plugins.p4.client.ConnectionHelper;
import org.jenkinsci.plugins.p4.credentials.P4BaseCredentials;
import org.kohsuke.stapler.DataBoundConstructor;

public class P4Trigger
extends Trigger<Job<?, ?>> {
    static final Logger LOGGER = Logger.getLogger(P4Trigger.class.getName());

    @DataBoundConstructor
    public P4Trigger() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void poke(Job<?, ?> job, String port) throws IOException {
        if (!this.matchServer(job, port)) {
            return;
        }
        LOGGER.info("P4: poking: " + job.getName());
        StreamTaskListener listener = new StreamTaskListener(this.getLogFile());
        try {
            PrintStream log = listener.getLogger();
            SCMTriggerItem item = SCMTriggerItem.SCMTriggerItems.asSCMTriggerItem(job);
            PollingResult pollResult = item.poll((TaskListener)listener);
            if (pollResult.hasChanges()) {
                log.println("Changes found");
            } else {
                log.println("No changes");
            }
        }
        catch (Exception e) {
            String msg = "P4: Failed to record P4 trigger: ";
            e.printStackTrace(listener.error(msg));
            LOGGER.severe(msg + e);
        }
        finally {
            listener.close();
        }
    }

    public File getLogFile() {
        return new File(((Job)this.job).getRootDir(), "p4trigger.log");
    }

    private boolean matchServer(Job<?, ?> job, String port) {
        PerforceScm p4scm;
        String id;
        P4BaseCredentials credential;
        AbstractProject project;
        SCM scm;
        return job instanceof AbstractProject && (scm = (project = (AbstractProject)job).getScm()) instanceof PerforceScm && port.equals((credential = ConnectionHelper.findCredential(id = (p4scm = (PerforceScm)scm).getCredential())).getP4port());
    }

    public Collection<? extends Action> getProjectActions() {
        return Collections.singleton(new P4TriggerAction());
    }

    public final class P4TriggerAction
    implements Action {
        public Job<?, ?> getOwner() {
            return (Job)P4Trigger.this.job;
        }

        public String getIconFileName() {
            return "clipboard.png";
        }

        public String getDisplayName() {
            return "P4 Trigger Log";
        }

        public String getUrlName() {
            return "P4TriggerLog";
        }

        public String getLog() throws IOException {
            return Util.loadFile((File)P4Trigger.this.getLogFile());
        }

        public void writeLogTo(XMLOutput out) throws IOException {
            new AnnotatedLargeText(P4Trigger.this.getLogFile(), Charset.defaultCharset(), true, (Object)this).writeHtmlTo(0L, out.asWriter());
        }
    }

    @Extension
    public static class DescriptorImpl
    extends TriggerDescriptor {
        public boolean isApplicable(Item item) {
            return item instanceof Job;
        }

        public String getDisplayName() {
            return "Perforce triggered build.";
        }
    }
}

