/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.trigger;

import hudson.Extension;
import hudson.model.Job;
import hudson.model.UnprotectedRootAction;
import hudson.triggers.Trigger;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.plugins.p4.trigger.P4Trigger;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class P4Hook
implements UnprotectedRootAction {
    static final Logger LOGGER = Logger.getLogger(P4Hook.class.getName());

    public String getIconFileName() {
        return "/plugin/p4/icons/p4.png";
    }

    public String getDisplayName() {
        return "P4 Trigger";
    }

    public String getUrlName() {
        return "p4";
    }

    public void doChange(StaplerRequest req) throws IOException {
        String body = IOUtils.toString((InputStream)req.getInputStream());
        String contentType = req.getContentType();
        if (contentType != null && contentType.startsWith("application/json")) {
            body = URLDecoder.decode(body, "UTF-8");
        }
        if (body.startsWith("payload=")) {
            body = body.substring(8);
            JSONObject payload = JSONObject.fromObject((Object)body);
            String port = payload.getString("p4port");
            String change = payload.getString("change");
            LOGGER.info("Received trigger event: " + body);
            this.probeJobs(port, change);
        }
    }

    private void probeJobs(String port, String change) throws IOException {
        for (Job job : Jenkins.getInstance().getAllItems(Job.class)) {
            P4Trigger trigger = null;
            LOGGER.fine("P4: trying: " + job.getName());
            if (job instanceof ParameterizedJobMixIn.ParameterizedJob) {
                ParameterizedJobMixIn.ParameterizedJob pJob = (ParameterizedJobMixIn.ParameterizedJob)job;
                for (Trigger t : pJob.getTriggers().values()) {
                    if (!(t instanceof P4Trigger)) continue;
                    trigger = (P4Trigger)t;
                    break;
                }
            }
            if (trigger != null) {
                LOGGER.info("P4: probing: " + job.getName());
                trigger.poke(job, port);
                continue;
            }
            LOGGER.fine("P4: trigger not set: " + job.getName());
        }
    }
}

