/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.tasks;

import hudson.FilePath;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Logger;
import jenkins.security.Roles;
import org.jenkinsci.plugins.p4.client.ClientHelper;
import org.jenkinsci.plugins.p4.tasks.AbstractTask;
import org.jenkinsci.remoting.RoleChecker;
import org.jenkinsci.remoting.RoleSensitive;

public class UnshelveTask
extends AbstractTask
implements FilePath.FileCallable<Boolean>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(UnshelveTask.class.getName());
    private final String resolve;
    private int shelf;

    public UnshelveTask(String resolve) {
        this.resolve = resolve;
    }

    public void setShelf(int shelf) {
        this.shelf = shelf;
    }

    @Override
    public Object task(ClientHelper p4) throws Exception {
        try {
            if (!this.checkConnection(p4)) {
                Boolean bl = false;
                return bl;
            }
            p4.unshelveFiles(this.shelf);
            p4.resolveFiles(this.resolve);
        }
        catch (Exception e) {
            p4.log("(p4):stop:exception\n");
            String msg = "Unable to publish workspace: " + e;
            logger.warning(msg);
            throw e;
        }
        finally {
            p4.disconnect();
        }
        return true;
    }

    public Boolean invoke(File workspace, VirtualChannel channel) throws IOException {
        return (Boolean)this.tryTask();
    }

    public void checkRoles(RoleChecker checker) throws SecurityException {
        checker.check((RoleSensitive)this, Roles.SLAVE);
    }
}

