/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.tasks;

import hudson.FilePath;
import hudson.model.Descriptor;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.security.Roles;
import org.jenkinsci.plugins.p4.PerforceScm;
import org.jenkinsci.plugins.p4.changes.P4Revision;
import org.jenkinsci.plugins.p4.client.ClientHelper;
import org.jenkinsci.plugins.p4.client.ConnectionHelper;
import org.jenkinsci.plugins.p4.credentials.P4BaseCredentials;
import org.jenkinsci.plugins.p4.populate.ForceCleanImpl;
import org.jenkinsci.plugins.p4.populate.Populate;
import org.jenkinsci.remoting.RoleChecker;
import org.jenkinsci.remoting.RoleSensitive;

public class RemoveClientTask
implements FilePath.FileCallable<Boolean>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(RemoveClientTask.class.getName());
    private final P4BaseCredentials credential;
    private final String client;
    private final Populate populate;
    private final boolean deleteClient;
    private final boolean deleteFiles;

    public RemoveClientTask(String credential, String client, Populate populate) {
        this.credential = ConnectionHelper.findCredential(credential);
        this.client = client;
        this.populate = populate;
        Descriptor scm = Jenkins.getInstance().getDescriptor(PerforceScm.class);
        PerforceScm.DescriptorImpl p4scm = (PerforceScm.DescriptorImpl)scm;
        this.deleteClient = p4scm.isDeleteClient();
        this.deleteFiles = p4scm.isDeleteFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean invoke(File workspace, VirtualChannel channel) throws IOException, InterruptedException {
        block7: {
            logger.info("Task: remove client.");
            ClientHelper p4 = new ClientHelper(this.credential, null, this.client, "utf8");
            try {
                Serializable forceClean;
                if (this.deleteFiles) {
                    forceClean = new ForceCleanImpl(true, false, this.populate.isQuiet(), null);
                    logger.info("P4: unsyncing client: " + this.client);
                    p4.syncFiles(new P4Revision(0), (Populate)forceClean);
                }
                if (!this.deleteClient) break block7;
                if (p4.isClient(this.client)) {
                    logger.info("P4: remove client: " + this.client);
                    p4.deleteClient(this.client);
                    break block7;
                }
                logger.warning("P4: Cannot find: " + this.client);
                forceClean = Boolean.valueOf(this.deleteFiles);
                return forceClean;
            }
            catch (Exception e) {
                logger.warning("P4: Not able to get connection");
                Boolean bl = false;
                return bl;
            }
            finally {
                p4.disconnect();
            }
        }
        return this.deleteFiles;
    }

    public void checkRoles(RoleChecker checker) throws SecurityException {
        checker.check((RoleSensitive)this, Roles.SLAVE);
    }
}

