/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.tasks;

import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.impl.generic.core.Changelist;
import hudson.FilePath;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import jenkins.security.Roles;
import org.jenkinsci.plugins.p4.changes.P4Revision;
import org.jenkinsci.plugins.p4.client.ClientHelper;
import org.jenkinsci.plugins.p4.filters.Filter;
import org.jenkinsci.plugins.p4.filters.FilterPathImpl;
import org.jenkinsci.plugins.p4.filters.FilterPerChangeImpl;
import org.jenkinsci.plugins.p4.filters.FilterUserImpl;
import org.jenkinsci.plugins.p4.tasks.AbstractTask;
import org.jenkinsci.remoting.RoleChecker;
import org.jenkinsci.remoting.RoleSensitive;

public class PollTask
extends AbstractTask
implements FilePath.FileCallable<List<Integer>>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<Filter> filter;
    private final boolean perChange;
    private String pin;

    public PollTask(List<Filter> filter) {
        this.filter = filter;
        boolean incremental = false;
        if (filter != null) {
            for (Filter f : filter) {
                if (!(f instanceof FilterPerChangeImpl) || !((FilterPerChangeImpl)f).isPerChange()) continue;
                incremental = true;
            }
        }
        this.perChange = incremental;
    }

    public List<Integer> invoke(File workspace, VirtualChannel channel) throws IOException {
        return (List)this.tryTask();
    }

    @Override
    public Object task(ClientHelper p4) throws Exception {
        int last;
        List<Integer> have;
        List<Object> changes = new ArrayList();
        if (this.pin != null && !this.pin.isEmpty()) {
            have = p4.listHaveChanges(new P4Revision(this.pin));
            last = 0;
            if (!have.isEmpty()) {
                last = have.get(have.size() - 1);
            }
            p4.log("P4: Polling with label/change: " + last + "," + this.pin);
            changes = p4.listChanges(new P4Revision(last), new P4Revision(this.pin));
        } else {
            have = p4.listHaveChanges();
            last = 0;
            if (!have.isEmpty()) {
                last = have.get(have.size() - 1);
            }
            p4.log("P4: Polling with label/change: " + last + ",now");
            changes = p4.listChanges(new P4Revision(last));
        }
        ArrayList<Integer> remainder = new ArrayList<Integer>();
        Iterator<Object> i$ = changes.iterator();
        while (i$.hasNext()) {
            int c = (Integer)i$.next();
            Changelist changelist = p4.getChange(c);
            if (this.filterChange(changelist, this.filter)) continue;
            remainder.add(changelist.getId());
            p4.log("... found change: " + changelist.getId());
        }
        changes = remainder;
        if (!changes.isEmpty() && this.perChange) {
            int lowest = (Integer)changes.get(changes.size() - 1);
            changes = Arrays.asList(lowest);
            p4.log("next change: " + lowest);
        }
        return changes;
    }

    public void setLimit(String expandedPin) {
        this.pin = expandedPin;
    }

    private boolean filterChange(Changelist changelist, List<Filter> scmFilter) throws Exception {
        if (scmFilter == null) {
            return false;
        }
        String user = changelist.getUsername();
        ArrayList<IFileSpec> files = changelist.getFiles(true);
        for (Filter f : scmFilter) {
            String u;
            if (f instanceof FilterUserImpl && (u = ((FilterUserImpl)f).getUser()).equalsIgnoreCase(user)) {
                return true;
            }
            if (!(f instanceof FilterPathImpl)) continue;
            ArrayList<IFileSpec> remainder = new ArrayList<IFileSpec>();
            String path = ((FilterPathImpl)f).getPath();
            for (IFileSpec s : files) {
                String p = s.getDepotPathString();
                if (p.startsWith(path)) continue;
                remainder.add(s);
            }
            files = remainder;
            if (!files.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void checkRoles(RoleChecker checker) throws SecurityException {
        checker.check((RoleSensitive)this, Roles.SLAVE);
    }
}

