/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.tasks;

import com.perforce.p4java.core.IChangelistSummary;
import com.perforce.p4java.impl.generic.core.Changelist;
import com.perforce.p4java.impl.generic.core.Label;
import hudson.AbortException;
import hudson.FilePath;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import jenkins.security.Roles;
import org.jenkinsci.plugins.p4.changes.P4ChangeEntry;
import org.jenkinsci.plugins.p4.changes.P4Revision;
import org.jenkinsci.plugins.p4.client.ClientHelper;
import org.jenkinsci.plugins.p4.populate.Populate;
import org.jenkinsci.plugins.p4.review.ReviewProp;
import org.jenkinsci.plugins.p4.tasks.AbstractTask;
import org.jenkinsci.plugins.p4.tasks.CheckoutStatus;
import org.jenkinsci.plugins.p4.workspace.Expand;
import org.jenkinsci.plugins.p4.workspace.Workspace;
import org.jenkinsci.remoting.RoleChecker;
import org.jenkinsci.remoting.RoleSensitive;

public class CheckoutTask
extends AbstractTask
implements FilePath.FileCallable<Boolean>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(CheckoutTask.class.getName());
    private final Populate populate;
    private CheckoutStatus status;
    private int head;
    private P4Revision buildChange;
    private int review;

    public CheckoutTask(Populate populate) {
        this.populate = populate;
    }

    public void initialise() throws AbortException {
        ClientHelper p4 = this.getConnection();
        try {
            Label labelSpec;
            String revSpec;
            String label;
            this.status = this.getStatus(this.getWorkspace());
            this.head = p4.getClientHead();
            this.review = this.getReview(this.getWorkspace());
            this.buildChange = this.getBuildChange(this.getWorkspace());
            if (this.buildChange.isLabel() && p4.isLabel(label = this.buildChange.toString()) && (revSpec = (labelSpec = p4.getLabel(label)).getRevisionSpec()) != null && !revSpec.isEmpty() && revSpec.startsWith("@")) {
                try {
                    int change = Integer.parseInt(revSpec.substring(1));
                    this.buildChange = new P4Revision(change);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            String err = "P4: Unable to initialise CheckoutTask: " + e;
            logger.severe(err);
            p4.log(err);
            throw new AbortException(err);
        }
        finally {
            p4.disconnect();
        }
    }

    public Boolean invoke(File workspace, VirtualChannel channel) throws IOException {
        return (Boolean)this.tryTask();
    }

    @Override
    public Object task(ClientHelper p4) throws Exception {
        p4.tidyWorkspace(this.populate);
        p4.syncFiles(this.buildChange, this.populate);
        if (this.status == CheckoutStatus.SHELVED) {
            p4.unshelveFiles(this.review);
        }
        return true;
    }

    private CheckoutStatus getStatus(Workspace workspace) {
        CheckoutStatus status = CheckoutStatus.HEAD;
        String value = workspace.getExpand().get(ReviewProp.STATUS.toString());
        if (value != null && !value.isEmpty()) {
            status = CheckoutStatus.parse(value);
        }
        return status;
    }

    private P4Revision getBuildChange(Workspace workspace) {
        P4Revision build;
        block10: {
            String lblStr;
            String cngStr;
            int change2;
            Expand expand;
            block9: {
                String expandedPopulateLabel;
                build = new P4Revision(this.head);
                expand = workspace.getExpand();
                String populateLabel = this.populate.getPin();
                if (populateLabel != null && !populateLabel.isEmpty() && !(expandedPopulateLabel = expand.format(populateLabel, false)).isEmpty()) {
                    try {
                        change2 = Integer.parseInt(expandedPopulateLabel);
                        build = new P4Revision(change2);
                    }
                    catch (NumberFormatException e) {
                        if ("now".equals(expandedPopulateLabel)) break block9;
                        build = new P4Revision(expandedPopulateLabel);
                    }
                }
            }
            if ((cngStr = expand.get(ReviewProp.CHANGE.toString())) != null && !cngStr.isEmpty()) {
                try {
                    change2 = Integer.parseInt(cngStr);
                    build = new P4Revision(change2);
                }
                catch (NumberFormatException change2) {
                    // empty catch block
                }
            }
            if ((lblStr = expand.get(ReviewProp.LABEL.toString())) != null && !lblStr.isEmpty()) {
                try {
                    int change3 = Integer.parseInt(lblStr);
                    build = new P4Revision(change3);
                }
                catch (NumberFormatException e) {
                    if ("now".equals(lblStr)) break block10;
                    build = new P4Revision(lblStr);
                }
            }
        }
        return build;
    }

    private int getReview(Workspace workspace) {
        int review = 0;
        Expand expand = workspace.getExpand();
        String value = expand.get(ReviewProp.REVIEW.toString());
        if (value != null && !value.isEmpty()) {
            try {
                review = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return review;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> getChanges(P4Revision last) {
        ArrayList<Integer> changes = new ArrayList();
        ClientHelper p4 = this.getConnection();
        try {
            changes = p4.listChanges(last, this.buildChange);
        }
        catch (Exception e) {
            String err = "Unable to get changes: " + e;
            logger.severe(err);
            p4.log(err);
            e.printStackTrace();
        }
        finally {
            p4.disconnect();
        }
        if (this.status == CheckoutStatus.SHELVED) {
            changes.add(this.review);
        }
        return changes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<P4ChangeEntry> getChangesFull(P4Revision last) {
        ArrayList<P4ChangeEntry> changesFull = new ArrayList<P4ChangeEntry>();
        List<Object> changes = new ArrayList();
        ClientHelper p4 = this.getConnection();
        try {
            if (this.status == CheckoutStatus.SHELVED) {
                P4ChangeEntry cl = new P4ChangeEntry();
                Changelist changelist = p4.getChange(this.review);
                cl.setChange(p4, (IChangelistSummary)changelist);
                changesFull.add(cl);
            }
            changes = p4.listChanges(last, this.buildChange);
            for (Integer n : changes) {
                P4ChangeEntry cl = new P4ChangeEntry();
                IChangelistSummary summary = p4.getChangeSummary(n);
                cl.setChange(p4, summary);
                changesFull.add(cl);
            }
        }
        catch (Exception e) {
            String string = "Unable to get full changes: " + e;
            logger.severe(string);
            p4.log(string);
            e.printStackTrace();
        }
        finally {
            p4.disconnect();
        }
        return changesFull;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public P4ChangeEntry getCurrentChange() {
        P4ChangeEntry cl = new P4ChangeEntry();
        P4Revision current = this.getBuildChange();
        ClientHelper p4 = this.getConnection();
        try {
            cl = current.getChangeEntry(p4);
        }
        catch (Exception e) {
            String err = "Unable to get current change: " + e;
            logger.severe(err);
            p4.log(err);
            e.printStackTrace();
        }
        finally {
            p4.disconnect();
        }
        return cl;
    }

    public CheckoutStatus getStatus() {
        return this.status;
    }

    public P4Revision getSyncChange() {
        return this.buildChange;
    }

    public P4Revision getBuildChange() {
        if (this.status == CheckoutStatus.SHELVED) {
            return new P4Revision(this.review);
        }
        return this.buildChange;
    }

    public void setBuildChange(P4Revision parentChange) {
        this.buildChange = parentChange;
    }

    public int getReview() {
        return this.review;
    }

    public void checkRoles(RoleChecker checker) throws SecurityException {
        checker.check((RoleSensitive)this, Roles.SLAVE);
    }
}

