/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.tasks;

import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.jenkinsci.plugins.p4.client.ClientHelper;
import org.jenkinsci.plugins.p4.client.ConnectionHelper;
import org.jenkinsci.plugins.p4.credentials.P4BaseCredentials;
import org.jenkinsci.plugins.p4.review.ReviewProp;
import org.jenkinsci.plugins.p4.tasks.HostnameTask;
import org.jenkinsci.plugins.p4.workspace.TemplateWorkspaceImpl;
import org.jenkinsci.plugins.p4.workspace.Workspace;

public abstract class AbstractTask
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(AbstractTask.class.getName());
    private P4BaseCredentials credential;
    private TaskListener listener;
    private String client;
    private String charset;
    private transient Workspace workspace;

    public abstract Object task(ClientHelper var1) throws Exception;

    public P4BaseCredentials getCredential() {
        return this.credential;
    }

    public void setCredential(String credential) {
        this.credential = ConnectionHelper.findCredential(credential);
    }

    public TaskListener getListener() {
        return this.listener;
    }

    public void setListener(TaskListener listener) {
        this.listener = listener;
    }

    public void setWorkspace(Workspace workspace) throws AbortException {
        this.workspace = workspace;
        this.client = workspace.getFullName();
        this.charset = workspace.getCharset();
        ClientHelper p4 = this.getConnection();
        if (!this.checkConnection(p4)) {
            String err = "P4: Abort, no server connection.\n";
            logger.severe(err);
            p4.log(err);
            throw new AbortException(err);
        }
        try {
            p4.setClient(workspace);
            p4.log("... client: " + this.getClient());
        }
        catch (Exception e) {
            String err = "P4: Unable to setup workspace: " + e;
            logger.severe(err);
            p4.log(err);
            throw new AbortException(err);
        }
        finally {
            p4.disconnect();
        }
    }

    public Workspace setEnvironment(Run<?, ?> run, Workspace wsType, FilePath buildWorkspace) throws IOException, InterruptedException {
        Workspace ws = (Workspace)wsType.clone();
        EnvVars envVars = run.getEnvironment(this.listener);
        envVars.put("NODE_NAME", envVars.get("NODE_NAME", "master"));
        ws.setExpand((Map<String, String>)envVars);
        String root = buildWorkspace.getRemote();
        if (root.contains("@")) {
            root = root.replace("@", "%40");
            String client = ws.getFullName();
            String name = buildWorkspace.getName();
            String[] parts = name.split("@");
            String exec = parts[1];
            this.setWorkspace(ws);
            String charset = ws.getCharset();
            boolean pin = ws.isPinHost();
            String template = client + ".clone" + exec;
            ws = new TemplateWorkspaceImpl(charset, pin, client, template);
            ws.setExpand((Map<String, String>)envVars);
        }
        ws.setRootPath(root);
        if (ws.isPinHost()) {
            String hostname = AbstractTask.getHostName(buildWorkspace);
            ws.setHostName(hostname);
        } else {
            ws.setHostName("");
        }
        return ws;
    }

    public Workspace setNextChange(Workspace ws, List<Integer> changes) {
        if (changes != null && !changes.isEmpty()) {
            String label = Integer.toString(changes.get(0));
            ws.getExpand().set(ReviewProp.LABEL.toString(), label);
        }
        return ws;
    }

    private static String getHostName(FilePath buildWorkspace) {
        try {
            HostnameTask task = new HostnameTask();
            String hostname = (String)buildWorkspace.act((FilePath.FileCallable)task);
            return hostname;
        }
        catch (Exception e) {
            return "";
        }
    }

    protected String getClient() {
        return this.client;
    }

    protected Workspace getWorkspace() {
        return this.workspace;
    }

    protected ClientHelper getConnection() {
        ClientHelper p4 = new ClientHelper(this.credential, this.listener, this.client, this.charset);
        return p4;
    }

    protected boolean checkConnection(ClientHelper p4) {
        String host;
        p4.log("\nP4 Task: establishing connection.");
        if (!p4.isConnected()) {
            p4.log("P4: Server connection error: " + this.getCredential().getP4port());
            return false;
        }
        p4.log("... server: " + this.getCredential().getP4port());
        try {
            host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            host = "unknown";
        }
        p4.log("... node: " + host);
        return true;
    }

    protected Object tryTask() throws AbortException {
        ClientHelper p4 = this.getConnection();
        if (p4.hasAborted()) {
            String msg = "P4: Previous Task Aborted!";
            logger.warning(msg);
            p4.log(msg);
            p4.disconnect();
            throw new AbortException(msg);
        }
        if (!this.checkConnection(p4)) {
            String msg = "\nP4 Task: Unable to connect.";
            logger.warning(msg);
            p4.log(msg);
            throw new AbortException(msg);
        }
        int trys = 0;
        int attempt = p4.getRetry();
        Exception last = null;
        while (trys <= attempt) {
            String msg;
            ++trys;
            try {
                Object result = this.task(p4);
                p4.disconnect();
                if (p4.hasAborted()) {
                    msg = "P4: Task Aborted!";
                    logger.warning(msg);
                    p4.log(msg);
                    throw new AbortException(msg);
                }
                return result;
            }
            catch (AbortException e) {
                throw e;
            }
            catch (Exception e) {
                last = e;
                msg = "P4 Task: attempt: " + trys;
                logger.severe(msg);
                p4.log(msg);
                try {
                    TimeUnit.SECONDS.sleep(trys ^ 2);
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        p4.disconnect();
        String msg = "P4 Task: failed: " + last;
        last.printStackTrace();
        logger.warning(msg);
        p4.log(msg);
        throw new AbortException(msg);
    }
}

