/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.tagging;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.util.Map;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.p4.tagging.TagAction;
import org.jenkinsci.plugins.p4.workspace.Expand;
import org.kohsuke.stapler.DataBoundConstructor;

public class TagNotifier
extends Notifier {
    protected static final Logger LOGGER = Logger.getLogger(TagNotifier.class.getName());
    public final String rawLabelName;
    public final String rawLabelDesc;
    public final boolean onlyOnSuccess;
    private transient TaskListener listener;

    @DataBoundConstructor
    public TagNotifier(String rawLabelName, String rawLabelDesc, boolean onlyOnSuccess) {
        this.rawLabelName = rawLabelName;
        this.rawLabelDesc = rawLabelDesc;
        this.onlyOnSuccess = onlyOnSuccess;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException {
        this.listener = listener;
        if (this.onlyOnSuccess && build.getResult() != Result.SUCCESS) {
            return true;
        }
        try {
            EnvVars env = build.getEnvironment((TaskListener)listener);
            Expand expand = new Expand((Map<String, String>)env);
            String name = expand.format(this.rawLabelName, false);
            String description = expand.format(this.rawLabelDesc, false);
            TagAction tagAction = this.getTagAction(env, build);
            FilePath workspace = build.getWorkspace();
            tagAction.labelBuild((TaskListener)listener, name, description, workspace);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    private TagAction getTagAction(EnvVars env, AbstractBuild<?, ?> build) {
        TagAction tagAction = (TagAction)build.getAction(TagAction.class);
        if (tagAction == null) {
            int buildNum;
            String jobName = (String)env.get((Object)"PROMOTED_JOB_NAME");
            if (jobName == null || jobName.isEmpty()) {
                this.log("No tag information; not a promotion job.");
                return tagAction;
            }
            String buildNumber = (String)env.get((Object)"PROMOTED_NUMBER");
            if (buildNumber == null || buildNumber.isEmpty()) {
                this.log("No tag information; not a promotion job.");
                return tagAction;
            }
            Jenkins j = Jenkins.getInstance();
            AbstractProject project = (AbstractProject)j.getItemByFullName(jobName, AbstractProject.class);
            build = project.getBuildByNumber(buildNum = Integer.parseInt(buildNumber));
            tagAction = (TagAction)build.getAction(TagAction.class);
            if (tagAction == null) {
                this.log("No tag information; is it a valid Perforce job?");
                return tagAction;
            }
        }
        return tagAction;
    }

    protected void log(String msg) {
        if (this.listener == null) {
            return;
        }
        this.listener.getLogger().println(msg);
    }

    public static DescriptorImpl descriptor() {
        return (DescriptorImpl)Jenkins.getInstance().getDescriptorByType(DescriptorImpl.class);
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Perforce: Label build";
        }
    }
}

