/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.tagging;

import com.perforce.p4java.impl.generic.core.Label;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.scm.AbstractScmTagAction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import org.jenkinsci.plugins.p4.PerforceScm;
import org.jenkinsci.plugins.p4.changes.P4Revision;
import org.jenkinsci.plugins.p4.client.ClientHelper;
import org.jenkinsci.plugins.p4.client.ConnectionHelper;
import org.jenkinsci.plugins.p4.credentials.P4BaseCredentials;
import org.jenkinsci.plugins.p4.tasks.TaggingTask;
import org.jenkinsci.plugins.p4.workspace.Expand;
import org.jenkinsci.plugins.p4.workspace.Workspace;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class TagAction
extends AbstractScmTagAction {
    private String tag;
    private List<String> tags = new ArrayList<String>();
    private String credential;
    private Workspace workspace;
    private String client;
    private P4Revision buildChange;
    private String charset;

    public TagAction(Run<?, ?> run) throws IOException, InterruptedException {
        super(run);
    }

    public String getIconFileName() {
        if (!this.getACL().hasPermission(PerforceScm.TAG)) {
            return null;
        }
        return "/plugin/p4/icons/label.gif";
    }

    public String getDisplayName() {
        if (this.isTagged()) {
            return "Perforce Label";
        }
        return "Label This Build";
    }

    public boolean isTagged() {
        return this.tags != null && !this.tags.isEmpty();
    }

    public void doSubmit(StaplerRequest req, StaplerResponse rsp) throws Exception, ServletException {
        this.getACL().checkPermission(PerforceScm.TAG);
        String description = req.getParameter("desc");
        String name = req.getParameter("name");
        this.labelBuild(null, name, description, null);
        rsp.sendRedirect(".");
    }

    public void labelBuild(TaskListener listener, String name, String description, FilePath nodeWorkspace) throws Exception {
        EnvVars env = this.getRun().getEnvironment(listener);
        Expand expand = new Expand((Map<String, String>)env);
        name = expand.format(name, false);
        description = expand.format(description, false);
        TaggingTask task = new TaggingTask(name, description);
        task.setListener(listener);
        task.setCredential(this.credential);
        task.setWorkspace(this.workspace);
        task.setBuildChange(this.buildChange);
        FilePath buildWorkspace = nodeWorkspace;
        if (nodeWorkspace == null) {
            buildWorkspace = this.build.getWorkspace();
        }
        buildWorkspace.act((FilePath.FileCallable)task);
        if (!this.tags.contains(name)) {
            this.tags.add(name);
            this.getRun().save();
        }
    }

    public void setBuildChange(P4Revision buildChange) {
        this.buildChange = buildChange;
    }

    public P4Revision getBuildChange() {
        return this.buildChange;
    }

    public String getCredential() {
        return this.credential;
    }

    public void setCredential(String credential) {
        this.credential = credential;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
        this.client = workspace.getFullName();
        this.charset = workspace.getCharset();
    }

    public String getPort() {
        P4BaseCredentials auth = ConnectionHelper.findCredential(this.credential);
        String p4port = auth.getP4port();
        return p4port;
    }

    public String getClient() {
        return this.client;
    }

    public String getUser() {
        P4BaseCredentials auth = ConnectionHelper.findCredential(this.credential);
        String p4user = auth.getUsername();
        return p4user;
    }

    public String getTicket() {
        ConnectionHelper p4 = new ConnectionHelper(this.credential, null);
        String p4ticket = p4.getTicket();
        return p4ticket;
    }

    public String getTag() {
        return this.tag;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public Label getLabel(String tag) throws Exception {
        ClientHelper p4 = new ClientHelper(this.credential, null, this.client, this.charset);
        Label label = p4.getLabel(tag);
        return label;
    }
}

