/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.review;

import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.ParameterDefinition;
import hudson.model.ParametersAction;
import hudson.model.Queue;
import hudson.model.StringParameterDefinition;
import hudson.model.StringParameterValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.util.TimeDuration;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.p4.review.ReviewProp;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class ReviewAction
implements Action {
    private final AbstractProject<?, ?> project;
    static final Logger LOGGER = Logger.getLogger(ReviewAction.class.getName());

    public AbstractProject<?, ?> getProject() {
        return this.project;
    }

    public ReviewAction(AbstractProject<?, ?> project) {
        this.project = project;
    }

    public String getIconFileName() {
        return "/plugin/p4/icons/p4.png";
    }

    public String getDisplayName() {
        return "Build Review";
    }

    public String getUrlName() {
        return "review";
    }

    public List<StringParameterValue> getAvailableParameters() {
        ArrayList<StringParameterValue> stringParameters = new ArrayList<StringParameterValue>();
        for (ParameterDefinition parameterDefinition : this.getParameterDefinitions()) {
            StringParameterValue stringParameter = new StringParameterValue(parameterDefinition.getName(), parameterDefinition.getDescription());
            stringParameters.add(stringParameter);
        }
        return stringParameters;
    }

    public void doBuildSubmit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        JSONObject formData = req.getSubmittedForm();
        if (!formData.isEmpty()) {
            this.doBuild(req, rsp);
        }
    }

    public void doBuild(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.project.checkPermission(AbstractProject.BUILD);
        ArrayList<StringParameterValue> values = new ArrayList<StringParameterValue>();
        ArrayList<StringParameterDefinition> defs = new ArrayList<StringParameterDefinition>();
        Enumeration names = req.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            defs.add(new StringParameterDefinition(name, null));
        }
        for (ParameterDefinition parameterDefinition : defs) {
            StringParameterValue value = (StringParameterValue)parameterDefinition.createValue(req);
            if (value.value == null || value.value.isEmpty()) continue;
            values.add(value);
        }
        TimeDuration delay = new TimeDuration((long)this.project.getQuietPeriod());
        CauseAction causeAction = new CauseAction((Cause)new Cause.UserIdCause());
        ParametersAction params = new ParametersAction(values);
        Queue queue = Jenkins.getInstance().getQueue();
        queue.schedule(this.project, delay.getTime(), new Action[]{params, causeAction});
        rsp.sendRedirect("../");
    }

    private List<ParameterDefinition> getParameterDefinitions() {
        ArrayList<ParameterDefinition> swarm = new ArrayList<ParameterDefinition>();
        swarm.add((ParameterDefinition)new StringParameterDefinition(ReviewProp.REVIEW.getProp(), null));
        swarm.add((ParameterDefinition)new StringParameterDefinition(ReviewProp.CHANGE.getProp(), null));
        swarm.add((ParameterDefinition)new StringParameterDefinition(ReviewProp.STATUS.getProp(), null));
        swarm.add((ParameterDefinition)new StringParameterDefinition(ReviewProp.PASS.getProp(), null));
        swarm.add((ParameterDefinition)new StringParameterDefinition(ReviewProp.FAIL.getProp(), null));
        swarm.add((ParameterDefinition)new StringParameterDefinition(ReviewProp.LABEL.toString(), null));
        return swarm;
    }
}

