/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.publish;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepMonitor;
import java.io.IOException;
import java.util.Map;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.plugins.p4.publish.Publish;
import org.jenkinsci.plugins.p4.publish.PublishNotifier;
import org.jenkinsci.plugins.p4.tasks.PublishTask;
import org.jenkinsci.plugins.p4.workspace.Workspace;
import org.kohsuke.stapler.DataBoundConstructor;

public class PublishNotifierStep
extends PublishNotifier
implements SimpleBuildStep {
    @DataBoundConstructor
    public PublishNotifierStep(String credential, Workspace workspace, Publish publish) {
        super(credential, workspace, publish);
    }

    @Override
    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public void perform(Run<?, ?> run, FilePath buildWorkspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        if (this.getPublish().isOnlyOnSuccess() && run.getResult() != Result.SUCCESS) {
            return;
        }
        Workspace ws = (Workspace)this.getWorkspace().clone();
        try {
            EnvVars envVars = run.getEnvironment(listener);
            ws.setExpand((Map<String, String>)envVars);
            ws.setRootPath(buildWorkspace.getRemote());
            String desc = this.getPublish().getDescription();
            desc = ws.getExpand().format(desc, false);
            this.getPublish().setExpandedDesc(desc);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        PublishTask task = new PublishTask(this.getPublish());
        task.setListener(listener);
        task.setCredential(this.getCredential());
        task.setWorkspace(ws);
        buildWorkspace.act((FilePath.FileCallable)task);
    }
}

