/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.publish;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.ItemGroup;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.p4.credentials.P4BaseCredentials;
import org.jenkinsci.plugins.p4.publish.Publish;
import org.jenkinsci.plugins.p4.tasks.PublishTask;
import org.jenkinsci.plugins.p4.workspace.Workspace;
import org.kohsuke.stapler.DataBoundConstructor;

public class PublishNotifier
extends Notifier {
    private final String credential;
    private final Workspace workspace;
    private final Publish publish;

    public String getCredential() {
        return this.credential;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public Publish getPublish() {
        return this.publish;
    }

    @DataBoundConstructor
    public PublishNotifier(String credential, Workspace workspace, Publish publish) {
        this.credential = credential;
        this.workspace = workspace;
        this.publish = publish;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (this.publish.isOnlyOnSuccess() && build.getResult() != Result.SUCCESS) {
            return true;
        }
        Workspace ws = (Workspace)this.workspace.clone();
        try {
            EnvVars envVars = build.getEnvironment((TaskListener)listener);
            ws.setExpand((Map<String, String>)envVars);
            ws.setRootPath(build.getWorkspace().getRemote());
            String desc = this.publish.getDescription();
            desc = ws.getExpand().format(desc, false);
            this.publish.setExpandedDesc(desc);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        PublishTask task = new PublishTask(this.publish);
        task.setListener((TaskListener)listener);
        task.setCredential(this.credential);
        task.setWorkspace(ws);
        FilePath buildWorkspace = build.getWorkspace();
        boolean success = (Boolean)buildWorkspace.act((FilePath.FileCallable)task);
        return success;
    }

    public static DescriptorImpl descriptor() {
        return (DescriptorImpl)Jenkins.getInstance().getDescriptorByType(DescriptorImpl.class);
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Perforce: Publish assets";
        }

        public ListBoxModel doFillCredentialItems() {
            ListBoxModel list = new ListBoxModel();
            Class<P4BaseCredentials> type = P4BaseCredentials.class;
            Jenkins scope = Jenkins.getInstance();
            Authentication acl = ACL.SYSTEM;
            DomainRequirement domain = new DomainRequirement();
            List credentials = CredentialsProvider.lookupCredentials(type, (ItemGroup)scope, (Authentication)acl, (DomainRequirement[])new DomainRequirement[]{domain});
            if (credentials.isEmpty()) {
                list.add("Select credential...", null);
            }
            for (P4BaseCredentials c : credentials) {
                StringBuffer sb = new StringBuffer();
                sb.append(c.getDescription());
                sb.append(" (");
                sb.append(c.getUsername());
                sb.append(":");
                sb.append(c.getP4port());
                sb.append(")");
                list.add(sb.toString(), c.getId());
            }
            return list;
        }
    }
}

