/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.filters;

import com.perforce.p4java.core.IUserSummary;
import com.perforce.p4java.server.IOptionsServer;
import hudson.Extension;
import hudson.model.AutoCompletionCandidates;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jenkinsci.plugins.p4.client.ConnectionFactory;
import org.jenkinsci.plugins.p4.filters.Filter;
import org.jenkinsci.plugins.p4.filters.FilterDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class FilterUserImpl
extends Filter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String user;

    @DataBoundConstructor
    public FilterUserImpl(String user) {
        this.user = user;
    }

    public String getUser() {
        return this.user;
    }

    @Extension
    public static final class DescriptorImpl
    extends FilterDescriptor {
        public String getDisplayName() {
            return "Exclude changes from user";
        }

        public AutoCompletionCandidates doAutoCompleteUser(@QueryParameter String value) {
            AutoCompletionCandidates c = new AutoCompletionCandidates();
            try {
                IOptionsServer iserver = ConnectionFactory.getConnection();
                if (iserver != null && value.length() > 0) {
                    ArrayList<String> users = new ArrayList<String>();
                    users.add(value + "*");
                    List list = iserver.getUsers(users, 10);
                    for (IUserSummary l : list) {
                        c.add(l.getLoginName());
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return c;
        }
    }
}

