/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.credentials;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.io.IOException;
import javax.servlet.ServletException;
import org.jenkinsci.plugins.p4.client.ConnectionConfig;
import org.jenkinsci.plugins.p4.client.ConnectionFactory;
import org.jenkinsci.plugins.p4.client.ConnectionHelper;
import org.jenkinsci.plugins.p4.credentials.P4BaseCredentials;
import org.jenkinsci.plugins.p4.credentials.TrustImpl;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class P4PasswordImpl
extends P4BaseCredentials {
    private static final long serialVersionUID = 1L;
    @CheckForNull
    private final Secret password;

    @DataBoundConstructor
    public P4PasswordImpl(CredentialsScope scope, String id, String description, @CheckForNull String p4port, TrustImpl ssl, @CheckForNull String username, @CheckForNull String retry, @CheckForNull String timeout, @CheckForNull String password) {
        super(scope, id, description, p4port, ssl, username, retry, timeout);
        this.password = Secret.fromString((String)password);
    }

    @CheckForNull
    public Secret getPassword() {
        return this.password;
    }

    @Extension
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        public String getDisplayName() {
            return "Perforce Password Credential";
        }

        public FormValidation doCheckP4port(@QueryParameter String value) {
            if (value != null && value.startsWith("ssl:")) {
                return FormValidation.error((String)"Do not prefix P4PORT with 'ssl:', use the SSL checkbox.");
            }
            return FormValidation.ok();
        }

        public FormValidation doTestConnection(@QueryParameter(value="p4port") String p4port, @QueryParameter(value="ssl") String ssl, @QueryParameter(value="trust") String trust, @QueryParameter(value="username") String username, @QueryParameter(value="retry") String retry, @QueryParameter(value="timeout") String timeout, @QueryParameter(value="password") String password) throws IOException, ServletException {
            try {
                ConnectionConfig config = new ConnectionConfig(p4port, "true".equals(ssl), trust);
                FormValidation validation = ConnectionFactory.testConnection(config);
                if (!FormValidation.ok().equals(validation)) {
                    return validation;
                }
                TrustImpl sslTrust = "true".equals(ssl) ? new TrustImpl(trust) : null;
                P4PasswordImpl test = new P4PasswordImpl(null, null, null, p4port, sslTrust, username, retry, timeout, password);
                ConnectionHelper p4 = new ConnectionHelper(test);
                if (!p4.isConnected()) {
                    return FormValidation.error((String)"Server Connection Error.");
                }
                p4.logout();
                if (!p4.login()) {
                    return FormValidation.error((String)"Authentication Error: Unable to login.");
                }
                if (!p4.checkVersion(20121)) {
                    return FormValidation.error((String)"Server version is too old (min 2012.1)");
                }
                return FormValidation.ok((String)"Success");
            }
            catch (Exception e) {
                return FormValidation.error((String)"Connection Error.");
            }
        }
    }
}

