/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.credentials;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Util;
import org.jenkinsci.plugins.p4.credentials.TrustImpl;

public abstract class P4BaseCredentials
extends BaseStandardCredentials {
    private static final long serialVersionUID = 1L;
    @CheckForNull
    private final String p4port;
    @CheckForNull
    private final TrustImpl ssl;
    @CheckForNull
    private final String username;
    @CheckForNull
    private final String retry;
    @CheckForNull
    private final String timeout;

    public P4BaseCredentials(CredentialsScope scope, String id, String description, @CheckForNull String p4port, @CheckForNull TrustImpl ssl, @CheckForNull String username, @CheckForNull String retry, @CheckForNull String timeout) {
        super(scope, id, description);
        this.p4port = Util.fixNull((String)p4port);
        this.ssl = ssl;
        this.username = Util.fixNull((String)username);
        this.retry = retry;
        this.timeout = timeout;
    }

    @CheckForNull
    public String getP4port() {
        return this.p4port;
    }

    public boolean isSsl() {
        return this.ssl != null;
    }

    @CheckForNull
    public String getTrust() {
        return this.ssl == null ? null : this.ssl.getTrust();
    }

    @CheckForNull
    public String getUsername() {
        return this.username;
    }

    public int getRetry() {
        if (this.retry != null && !this.retry.isEmpty()) {
            return Integer.parseInt(this.retry);
        }
        return 0;
    }

    public int getTimeout() {
        if (this.timeout != null && !this.timeout.isEmpty()) {
            return Integer.parseInt(this.timeout);
        }
        return 0;
    }
}

