/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.client;

import com.perforce.p4java.core.IDepot;
import com.perforce.p4java.core.file.FileSpecBuilder;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.option.server.GetDepotFilesOptions;
import com.perforce.p4java.option.server.GetDirectoriesOptions;
import com.perforce.p4java.server.IOptionsServer;
import hudson.model.AutoCompletionCandidates;
import java.util.List;
import org.jenkinsci.plugins.p4.client.ConnectionFactory;

public class NavigateHelper {
    public static AutoCompletionCandidates getPath(String value) {
        if (!value.startsWith("//")) {
            return null;
        }
        String depot = value.substring(2);
        if (!depot.contains("/")) {
            return NavigateHelper.listDepots(depot);
        }
        AutoCompletionCandidates c = new AutoCompletionCandidates();
        NavigateHelper.listDirs(value, c);
        NavigateHelper.listFiles(value, c);
        return c;
    }

    private static AutoCompletionCandidates listDepots(String value) {
        AutoCompletionCandidates c = new AutoCompletionCandidates();
        try {
            IOptionsServer iserver = ConnectionFactory.getConnection();
            if (iserver != null) {
                List list = iserver.getDepots();
                for (IDepot l : list) {
                    if (!l.getName().startsWith(value)) continue;
                    c.add("//" + l.getName());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return c;
    }

    private static void listDirs(String value, AutoCompletionCandidates c) {
        try {
            IOptionsServer iserver = ConnectionFactory.getConnection();
            if (iserver != null && value.length() > 4) {
                GetDirectoriesOptions opts;
                List dirs = FileSpecBuilder.makeFileSpecList((String)(value + "*"));
                List list = iserver.getDirectories(dirs, opts = new GetDirectoriesOptions());
                if (list == null) {
                    return;
                }
                if (list.size() > 10) {
                    list = list.subList(0, 10);
                }
                for (IFileSpec l : list) {
                    String dir = l.getOriginalPathString();
                    if (dir == null) continue;
                    c.add(dir);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void listFiles(String value, AutoCompletionCandidates c) {
        try {
            IOptionsServer iserver = ConnectionFactory.getConnection();
            if (iserver != null && value.length() > 4) {
                List files = FileSpecBuilder.makeFileSpecList((String)(value + "..."));
                GetDepotFilesOptions opts = new GetDepotFilesOptions();
                opts.setMaxResults(10);
                List list = iserver.getDepotFiles(files, opts);
                for (IFileSpec l : list) {
                    c.add(l.getDepotPathString());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

