/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.client;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.perforce.p4java.client.IClient;
import com.perforce.p4java.core.IChangelistSummary;
import com.perforce.p4java.core.IFix;
import com.perforce.p4java.core.ILabel;
import com.perforce.p4java.core.IUser;
import com.perforce.p4java.core.file.FileSpecBuilder;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.generic.core.Changelist;
import com.perforce.p4java.impl.generic.core.Label;
import com.perforce.p4java.impl.generic.core.file.FileSpec;
import com.perforce.p4java.impl.mapbased.server.Server;
import com.perforce.p4java.option.server.ChangelistOptions;
import com.perforce.p4java.option.server.DeleteClientOptions;
import com.perforce.p4java.option.server.GetChangelistsOptions;
import com.perforce.p4java.option.server.GetDepotFilesOptions;
import com.perforce.p4java.option.server.GetFixesOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.IServer;
import com.perforce.p4java.server.callback.ICommandCallback;
import com.perforce.p4java.server.callback.IProgressCallback;
import hudson.model.ItemGroup;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.util.LogTaskListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.p4.client.AuthorisationConfig;
import org.jenkinsci.plugins.p4.client.ConnectionConfig;
import org.jenkinsci.plugins.p4.client.ConnectionFactory;
import org.jenkinsci.plugins.p4.console.P4Logging;
import org.jenkinsci.plugins.p4.console.P4Progress;
import org.jenkinsci.plugins.p4.credentials.P4BaseCredentials;

public class ConnectionHelper {
    private static Logger logger = Logger.getLogger(ConnectionHelper.class.getName());
    private boolean abort = false;
    protected final ConnectionConfig connectionConfig;
    protected final AuthorisationConfig authorisationConfig;
    protected IOptionsServer connection;
    protected final TaskListener listener;
    protected final P4BaseCredentials p4credential;

    public ConnectionHelper(String credentialID, TaskListener listener) {
        P4BaseCredentials credential;
        this.listener = listener;
        this.p4credential = credential = ConnectionHelper.findCredential(credentialID);
        this.connectionConfig = new ConnectionConfig(credential);
        this.authorisationConfig = new AuthorisationConfig(credential);
        this.connectionRetry();
    }

    public ConnectionHelper(P4BaseCredentials credential, TaskListener listener) {
        this.listener = listener;
        this.p4credential = credential;
        this.connectionConfig = new ConnectionConfig(credential);
        this.authorisationConfig = new AuthorisationConfig(credential);
        this.connectionRetry();
    }

    public ConnectionHelper(P4BaseCredentials credential) {
        this.listener = new LogTaskListener(logger, Level.INFO);
        this.p4credential = credential;
        this.connectionConfig = new ConnectionConfig(credential);
        this.authorisationConfig = new AuthorisationConfig(credential);
        this.connectionRetry();
    }

    private boolean connect() {
        try {
            this.connection = ConnectionFactory.getConnection(this.connectionConfig);
            logger.fine("P4: opened connection OK");
        }
        catch (Exception e) {
            String err = "P4: Unable to connect: " + e;
            logger.severe(err);
            this.log(err);
            return false;
        }
        try {
            this.login();
        }
        catch (Exception e) {
            String err = "P4: Unable to login: " + e;
            logger.severe(err);
            this.log(err);
            return false;
        }
        P4Progress progress = new P4Progress(this.listener, this);
        this.connection.registerProgressCallback((IProgressCallback)progress);
        P4Logging logging = new P4Logging(this.listener);
        this.connection.registerCallback((ICommandCallback)logging);
        String ignore = ".p4ignore";
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("win")) {
            ignore = "p4ignore.txt";
        }
        Server server = (Server)this.connection;
        server.setIgnoreFileName(ignore);
        return true;
    }

    private void connectionRetry() {
        String err;
        int trys = 0;
        int attempt = this.getRetry();
        while (trys <= attempt) {
            if (this.connect()) {
                return;
            }
            err = "P4: Connection retry: " + ++trys;
            logger.severe(err);
            this.log(err);
            try {
                TimeUnit.SECONDS.sleep(trys ^ 2);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        err = "P4: Connection retry giving up...";
        logger.severe(err);
        this.log(err);
    }

    public int getRetry() {
        return this.p4credential.getRetry();
    }

    public String getPort() {
        return this.p4credential.getP4port();
    }

    public String getTrust() throws Exception {
        return this.connection.getTrust();
    }

    public String getTicket() {
        try {
            if (this.login()) {
                return this.connection.getAuthTicket();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public boolean isConnected() {
        if (this.connection == null) {
            return false;
        }
        return this.connection.isConnected();
    }

    public boolean isUnicode() {
        try {
            return this.connection.getServerInfo().isUnicodeEnabled();
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean checkVersion(int min) {
        int ver = this.connection.getServerVersionNumber();
        return ver >= min;
    }

    public boolean login() throws Exception {
        this.connection.setUserName(this.authorisationConfig.getUsername());
        if (this.connection.getServerInfo().isUnicodeEnabled()) {
            this.connection.setCharsetName("utf8");
        }
        switch (this.authorisationConfig.getType()) {
            case PASSWORD: {
                if (this.isLogin()) break;
                String pass = this.authorisationConfig.getPassword();
                this.connection.login(pass);
                break;
            }
            case TICKET: {
                String ticket = this.authorisationConfig.getTicketValue();
                this.connection.setAuthTicket(ticket);
                break;
            }
            case TICKETPATH: {
                String path = this.authorisationConfig.getTicketPath();
                this.connection.setTicketsFilePath(path);
                break;
            }
            default: {
                throw new Exception("Unknown Authorisation type: " + (Object)((Object)this.authorisationConfig.getType()));
            }
        }
        if (this.isLogin()) {
            return true;
        }
        String status = this.connection.getLoginStatus();
        logger.info("P4: login failed '" + status + "'");
        return false;
    }

    public void logout() throws Exception {
        if (this.isLogin()) {
            this.connection.logout();
        }
    }

    private boolean isLogin() throws Exception {
        String status = this.connection.getLoginStatus();
        if (status.contains("not necessary")) {
            return true;
        }
        if (status.contains("ticket expires in")) {
            return true;
        }
        return status.isEmpty();
    }

    public Changelist getChange(int id) throws Exception {
        try {
            return (Changelist)this.connection.getChangelist(id);
        }
        catch (RequestException e) {
            ChangelistOptions opts = new ChangelistOptions();
            opts.setOriginalChangelist(true);
            return (Changelist)this.connection.getChangelist(id, opts);
        }
    }

    public IChangelistSummary getChangeSummary(int id) throws P4JavaException {
        List spec = FileSpecBuilder.makeFileSpecList((String)("@" + id));
        GetChangelistsOptions cngOpts = new GetChangelistsOptions();
        cngOpts.setLongDesc(true);
        cngOpts.setMaxMostRecent(1);
        List summary = this.connection.getChangelists(spec, cngOpts);
        return (IChangelistSummary)summary.get(0);
    }

    public List<IFix> getJobs(int id) throws P4JavaException {
        GetFixesOptions opts = new GetFixesOptions();
        opts.setChangelistId(id);
        List fixes = this.connection.getFixes(null, opts);
        return fixes;
    }

    public boolean isLabel(String name) throws Exception {
        if (name.equals("now")) {
            return false;
        }
        try {
            ILabel label = this.connection.getLabel(name);
            return label != null;
        }
        catch (RequestException e) {
            return false;
        }
    }

    public boolean isClient(String name) throws Exception {
        try {
            if (name == null) {
                return false;
            }
            IClient client = this.connection.getClient(name);
            return client != null;
        }
        catch (RequestException e) {
            return false;
        }
    }

    public void deleteClient(String name) throws Exception {
        DeleteClientOptions opts = new DeleteClientOptions();
        this.connection.deleteClient(name, opts);
    }

    public String getEmail(String userName) throws Exception {
        IUser user = this.connection.getUser(userName);
        if (user != null) {
            String email = user.getEmail();
            return email;
        }
        return "";
    }

    public Label getLabel(String id) throws Exception {
        return (Label)this.connection.getLabel(id);
    }

    public void setLabel(Label label) throws Exception {
        String user = this.connection.getUserName();
        label.setOwnerName(user);
        this.connection.updateLabel((ILabel)label);
    }

    public List<IFileSpec> getLabelFiles(String id, int limit) throws Exception {
        String path = "//...@" + id;
        List spec = FileSpecBuilder.makeFileSpecList((String)path);
        GetDepotFilesOptions opts = new GetDepotFilesOptions();
        opts.setMaxResults(limit);
        List tagged = this.connection.getDepotFiles(spec, opts);
        return tagged;
    }

    public List<IFileSpec> getChangeFiles(int id) throws Exception {
        List files = this.connection.getChangelistFiles(id);
        return files;
    }

    public List<IFileSpec> getShelvedFiles(int id) throws Exception {
        Map map;
        String cmd = CmdSpec.DESCRIBE.name();
        String[] args = new String[]{"-s", "-S", "" + id};
        List resultMaps = this.connection.execMapCmdList(cmd, args, null);
        ArrayList<IFileSpec> list = new ArrayList<IFileSpec>();
        if (resultMaps != null && resultMaps.size() > 0 && resultMaps.get(0) != null && (map = (Map)resultMaps.get(0)).containsKey("shelved")) {
            int i = 0;
            while (map.get("rev" + i) != null) {
                FileSpec fSpec = new FileSpec(map, (IServer)this.connection, i);
                fSpec.setChangelistId(id);
                list.add((IFileSpec)fSpec);
                ++i;
            }
        }
        return list;
    }

    public void disconnect() {
        try {
            this.connection.disconnect();
            logger.fine("P4: closed connection OK");
        }
        catch (Exception e) {
            String err = "P4: Unable to close Perforce connection.";
            logger.severe(err);
            this.log(err);
        }
    }

    public static P4BaseCredentials findCredential(String id) {
        Class<P4BaseCredentials> type = P4BaseCredentials.class;
        Jenkins scope = Jenkins.getInstance();
        Authentication acl = ACL.SYSTEM;
        DomainRequirement domain = new DomainRequirement();
        List list = CredentialsProvider.lookupCredentials(type, (ItemGroup)scope, (Authentication)acl, (DomainRequirement[])new DomainRequirement[]{domain});
        for (P4BaseCredentials c : list) {
            if (!c.getId().equals(id)) continue;
            return c;
        }
        return null;
    }

    public void log(String msg) {
        if (this.listener == null) {
            return;
        }
        this.listener.getLogger().println(msg);
    }

    public void stop() throws Exception {
        this.connection.execMapCmd("admin", new String[]{"stop"}, null);
    }

    public boolean hasAborted() {
        return this.abort;
    }

    public void abort() {
        this.abort = true;
        this.disconnect();
    }
}

