/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.client;

import java.io.Serializable;
import org.jenkinsci.plugins.p4.credentials.P4BaseCredentials;

public class ConnectionConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String p4port;
    private final boolean ssl;
    private final String serverUri;
    private final String trust;
    private final int timeout;

    public ConnectionConfig(P4BaseCredentials credential) {
        this.p4port = credential.getP4port();
        this.ssl = credential.isSsl();
        this.trust = credential.getTrust();
        this.serverUri = this.toUri();
        this.timeout = credential.getTimeout();
    }

    public ConnectionConfig(String p4port, boolean ssl, String trust) {
        this.p4port = p4port;
        this.ssl = ssl;
        this.trust = trust;
        this.serverUri = this.toUri();
        this.timeout = 0;
    }

    private String toUri() {
        if (this.ssl) {
            return "p4javassl://" + this.p4port;
        }
        return "p4java://" + this.p4port;
    }

    public String getPort() {
        return this.p4port;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public String getTrust() {
        return this.trust;
    }

    public String getServerUri() {
        return this.serverUri;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public String toString() {
        return this.serverUri;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConnectionConfig) {
            ConnectionConfig comp = (ConnectionConfig)obj;
            return this.toString().equals(comp.toString());
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 1777 * hash + this.toString().hashCode();
        return hash;
    }
}

