/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.client;

import com.perforce.p4java.client.IClient;
import com.perforce.p4java.client.IClientSummary;
import com.perforce.p4java.core.IChangelist;
import com.perforce.p4java.core.IChangelistSummary;
import com.perforce.p4java.core.file.FileAction;
import com.perforce.p4java.core.file.FileSpecBuilder;
import com.perforce.p4java.core.file.FileSpecOpStatus;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.impl.generic.client.ClientView;
import com.perforce.p4java.impl.generic.core.Changelist;
import com.perforce.p4java.impl.generic.core.file.FileSpec;
import com.perforce.p4java.option.changelist.SubmitOptions;
import com.perforce.p4java.option.client.ReconcileFilesOptions;
import com.perforce.p4java.option.client.ReopenFilesOptions;
import com.perforce.p4java.option.client.ResolveFilesAutoOptions;
import com.perforce.p4java.option.client.RevertFilesOptions;
import com.perforce.p4java.option.client.SyncOptions;
import com.perforce.p4java.option.server.GetChangelistsOptions;
import com.perforce.p4java.option.server.GetFileContentsOptions;
import com.perforce.p4java.option.server.OpenedFilesOptions;
import com.perforce.p4java.server.callback.IStreamingCallback;
import hudson.AbortException;
import hudson.model.TaskListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.jenkinsci.plugins.p4.changes.P4Revision;
import org.jenkinsci.plugins.p4.client.ConnectionHelper;
import org.jenkinsci.plugins.p4.client.SyncStreamingCallback;
import org.jenkinsci.plugins.p4.client.Validate;
import org.jenkinsci.plugins.p4.credentials.P4BaseCredentials;
import org.jenkinsci.plugins.p4.populate.AutoCleanImpl;
import org.jenkinsci.plugins.p4.populate.CheckOnlyImpl;
import org.jenkinsci.plugins.p4.populate.ForceCleanImpl;
import org.jenkinsci.plugins.p4.populate.Populate;
import org.jenkinsci.plugins.p4.populate.SyncOnlyImpl;
import org.jenkinsci.plugins.p4.publish.Publish;
import org.jenkinsci.plugins.p4.publish.ShelveImpl;
import org.jenkinsci.plugins.p4.publish.SubmitImpl;
import org.jenkinsci.plugins.p4.tasks.TimeTask;
import org.jenkinsci.plugins.p4.workspace.StaticWorkspaceImpl;
import org.jenkinsci.plugins.p4.workspace.TemplateWorkspaceImpl;
import org.jenkinsci.plugins.p4.workspace.Workspace;

public class ClientHelper
extends ConnectionHelper {
    private static Logger logger = Logger.getLogger(ClientHelper.class.getName());
    private final Validate validate;
    private IClient iclient;

    public ClientHelper(String credential, TaskListener listener, String client, String charset) {
        super(credential, listener);
        this.clientLogin(client, charset);
        this.validate = new Validate(listener);
    }

    public ClientHelper(P4BaseCredentials credential, TaskListener listener, String client, String charset) {
        super(credential, listener);
        this.clientLogin(client, charset);
        this.validate = new Validate(listener);
    }

    private void clientLogin(String client, String charset) {
        if (this.connection == null) {
            return;
        }
        try {
            this.iclient = this.connection.getClient(client);
            this.connection.setCurrentClient(this.iclient);
        }
        catch (Exception e) {
            String err = "P4: Unable to use Workspace: " + e;
            logger.severe(err);
            this.log(err);
            e.printStackTrace();
        }
        if (this.isUnicode()) {
            this.connection.setCharsetName(charset);
        }
    }

    public void setClient(Workspace workspace) throws Exception {
        this.iclient = workspace.setClient(this.connection, this.authorisationConfig.getUsername());
        if (!this.isClientValid(workspace)) {
            String err = "P4: Undefined workspace: " + workspace.getFullName();
            throw new AbortException(err);
        }
        if (workspace instanceof StaticWorkspaceImpl) {
            this.connection.setCurrentClient(this.iclient);
            return;
        }
        if (workspace.getRootPath() != null) {
            this.iclient.setRoot(workspace.getRootPath());
        }
        if (workspace.getHostName() != null) {
            this.iclient.setHostName(workspace.getHostName());
        }
        IClientSummary.IClientOptions options = this.iclient.getOptions();
        options.setClobber(true);
        this.iclient.setOptions(options);
        this.iclient.update();
        this.connection.setCurrentClient(this.iclient);
    }

    public void syncFiles(P4Revision buildChange, Populate populate) throws Exception {
        TimeTask timer = new TimeTask();
        if (buildChange.isLabel()) {
            String label = buildChange.toString();
            try {
                int change = Integer.parseInt(label);
                this.log("P4 Task: label is a number! syncing files at change: " + change);
            }
            catch (NumberFormatException e) {
                if (!this.isLabel(label) && !this.isClient(label)) {
                    String msg = "P4: Unable to find client/label: " + label;
                    this.log(msg);
                    logger.warning(msg);
                    throw new AbortException(msg);
                }
                this.log("P4 Task: syncing files at client/label: " + label);
            }
        } else {
            this.log("P4 Task: syncing files at change: " + buildChange);
        }
        String path = this.iclient.getRoot() + "/...";
        String revisions = path + "@" + buildChange;
        List files = FileSpecBuilder.makeFileSpecList((String)revisions);
        if (populate instanceof CheckOnlyImpl) {
            this.syncHaveList(files, populate);
        } else {
            this.syncFiles(files, populate);
        }
        this.log("duration: " + timer.toString() + "\n");
    }

    private boolean syncHaveList(List<IFileSpec> files, Populate populate) throws Exception {
        SyncOptions syncOpts = new SyncOptions();
        syncOpts.setClientBypass(true);
        syncOpts.setQuiet(populate.isQuiet());
        List syncMsg = this.iclient.sync(files, syncOpts);
        this.validate.check((List<IFileSpec>)syncMsg, "file(s) up-to-date.", "file does not exist", "no file(s) as of that date");
        for (IFileSpec fileSpec : syncMsg) {
            String msg;
            if (fileSpec.getOpStatus() == FileSpecOpStatus.VALID || !(msg = fileSpec.getStatusMessage()).contains("file(s) up-to-date.")) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncFiles(List<IFileSpec> files, Populate populate) throws Exception {
        SyncStreamingCallback callback;
        IClientSummary.IClientOptions options;
        if (populate.isModtime() && !this.checkVersion(20151) && !(options = this.iclient.getOptions()).isModtime()) {
            options.setModtime(true);
            this.iclient.setOptions(options);
            this.iclient.update();
        }
        SyncOptions syncOpts = new SyncOptions();
        syncOpts.setServerBypass(!populate.isHave());
        syncOpts.setForceUpdate(populate.isForce() && populate.isHave());
        syncOpts.setQuiet(populate.isQuiet());
        SyncStreamingCallback syncStreamingCallback = callback = new SyncStreamingCallback(this.iclient.getServer(), this.listener);
        synchronized (syncStreamingCallback) {
            this.iclient.sync(files, syncOpts, (IStreamingCallback)callback, 0);
            while (!callback.isDone()) {
                callback.wait();
            }
        }
    }

    public void tidyWorkspace(Populate populate) throws Exception {
        this.log("");
        String path = this.iclient.getRoot() + "/...";
        List files = FileSpecBuilder.makeFileSpecList((String)path);
        if (populate instanceof AutoCleanImpl) {
            this.tidyAutoCleanImpl(populate, files);
        }
        if (populate instanceof ForceCleanImpl) {
            this.tidyForceSyncImpl(populate, files);
        }
        if (populate instanceof SyncOnlyImpl) {
            this.tidySyncOnlyImpl(populate, files);
        }
    }

    private void tidySyncOnlyImpl(Populate populate, List<IFileSpec> files) throws Exception {
        SyncOnlyImpl syncOnly = (SyncOnlyImpl)populate;
        if (syncOnly.isRevert()) {
            this.tidyPending(files);
        }
    }

    private void tidyForceSyncImpl(Populate populate, List<IFileSpec> files) throws Exception {
        this.tidyPending(files);
        String revisions = this.iclient.getRoot() + "/...#0";
        files = FileSpecBuilder.makeFileSpecList((String)revisions);
        boolean quiet = populate.isQuiet();
        AutoCleanImpl clean = new AutoCleanImpl(false, false, false, quiet, null);
        this.syncFiles(files, (Populate)clean);
        String root = this.iclient.getRoot();
        this.log("... rm -rf " + root);
        this.silentlyForceDelete(root);
    }

    private void silentlyForceDelete(String root) throws IOException {
        try {
            FileUtils.forceDelete((File)new File(root));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private void tidyAutoCleanImpl(Populate populate, List<IFileSpec> files) throws Exception {
        this.tidyPending(files);
        this.tidyClean(files, populate);
    }

    private void tidyPending(List<IFileSpec> files) throws Exception {
        TimeTask timer = new TimeTask();
        this.log("P4 Task: reverting all pending and shelved revisions.");
        RevertFilesOptions rOpts = new RevertFilesOptions();
        List list = this.iclient.revertFiles(files, rOpts);
        this.validate.check((List<IFileSpec>)list, "not opened on this client");
        this.log("... rm [abandoned files]");
        for (IFileSpec file : list) {
            if (file.getAction() != FileAction.ABANDONED) continue;
            String path = file.getLocalPathString();
            if (path == null) {
                path = this.depotToLocal(file);
            }
            if (path == null) continue;
            File unlink = new File(path);
            unlink.delete();
        }
        this.log("duration: " + timer.toString() + "\n");
    }

    private void tidyClean(List<IFileSpec> files, Populate populate) throws Exception {
        if (!this.checkVersion(20141)) {
            this.tidyRevisions(files, populate);
            return;
        }
        boolean delete = ((AutoCleanImpl)populate).isDelete();
        boolean replace = ((AutoCleanImpl)populate).isReplace();
        String[] base = new String[]{"-w", "-f"};
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(Arrays.asList(base));
        if (delete && !replace) {
            list.add("-a");
        }
        if (replace && !delete) {
            list.add("-e");
            list.add("-d");
        }
        if (!replace && !delete) {
            this.log("P4 Task: skipping clean, no options set.");
            return;
        }
        if (populate.isModtime()) {
            if (this.checkVersion(20141)) {
                list.add("-m");
            } else {
                this.log("P4: Resolving files by MODTIME not supported (requires 2014.1 or above)");
            }
        }
        TimeTask timer = new TimeTask();
        this.log("P4 Task: cleaning workspace to match have list.");
        String[] args = list.toArray(new String[list.size()]);
        ReconcileFilesOptions cleanOpts = new ReconcileFilesOptions(args);
        List status = this.iclient.reconcileFiles(files, cleanOpts);
        this.validate.check((List<IFileSpec>)status, "also opened by", "no file(s) to reconcile", "must sync/resolve", "exclusive file already opened", "cannot submit from stream", "instead of", "empty, assuming text");
        this.log("duration: " + timer.toString() + "\n");
    }

    private void tidyRevisions(List<IFileSpec> files, Populate populate) throws Exception {
        TimeTask timer = new TimeTask();
        this.log("P4 Task: tidying workspace to match have list.");
        boolean delete = ((AutoCleanImpl)populate).isDelete();
        boolean replace = ((AutoCleanImpl)populate).isReplace();
        String[] base = new String[]{"-n", "-a", "-e", "-d", "-l", "-f"};
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(Arrays.asList(base));
        String[] args = list.toArray(new String[list.size()]);
        ReconcileFilesOptions statusOpts = new ReconcileFilesOptions(args);
        List status = this.iclient.reconcileFiles(files, statusOpts);
        this.validate.check((List<IFileSpec>)status, "also opened by", "no file(s) to reconcile", "must sync/resolve", "exclusive file already opened", "cannot submit from stream", "instead of", "empty, assuming text");
        ArrayList<Object> update = new ArrayList<Object>();
        block3: for (IFileSpec s : status) {
            if (s.getOpStatus() == FileSpecOpStatus.VALID) {
                String path = s.getLocalPathString();
                if (path == null) {
                    path = this.depotToLocal(s);
                }
                switch (s.getAction()) {
                    case ADD: {
                        if (path == null || !delete) continue block3;
                        File unlink = new File(path);
                        unlink.delete();
                        break;
                    }
                    default: {
                        update.add(s);
                        break;
                    }
                }
                continue;
            }
            String msg = s.getStatusMessage();
            if (!msg.contains("exclusive file already opened")) continue;
            String rev = msg.substring(0, msg.indexOf(" - can't "));
            FileSpec spec = new FileSpec(rev);
            update.add(spec);
        }
        if (!update.isEmpty() && replace) {
            SyncOptions syncOpts = new SyncOptions();
            syncOpts.setForceUpdate(true);
            syncOpts.setQuiet(populate.isQuiet());
            List syncMsg = this.iclient.sync(update, syncOpts);
            this.validate.check((List<IFileSpec>)syncMsg, "file(s) up-to-date.", "file does not exist");
        }
        this.log("duration: " + timer.toString() + "\n");
    }

    public void versionFile(String file, String desc) throws Exception {
        List files = FileSpecBuilder.makeFileSpecList((String)file);
        this.findChangeFiles(files);
        if (!this.isOpened(files)) {
            return;
        }
        IChangelist change = this.createChangeList(files, desc);
        this.submitFiles(change, false);
    }

    public boolean buildChange() throws Exception {
        TimeTask timer = new TimeTask();
        this.log("P4 Task: reconcile files to changelist.");
        String ws = "//" + this.iclient.getName() + "/...";
        List files = FileSpecBuilder.makeFileSpecList((String)ws);
        this.findChangeFiles(files);
        boolean open = this.isOpened(files);
        this.log("duration: " + timer.toString() + "\n");
        return open;
    }

    private void findChangeFiles(List<IFileSpec> files) throws Exception {
        RevertFilesOptions revertOpts = new RevertFilesOptions();
        revertOpts.setNoClientRefresh(true);
        List revertStat = this.iclient.revertFiles(files, revertOpts);
        this.validate.check((List<IFileSpec>)revertStat, "");
        SyncOptions syncOpts = new SyncOptions();
        syncOpts.setClientBypass(true);
        List syncStat = this.iclient.sync(files, syncOpts);
        this.validate.check((List<IFileSpec>)syncStat, "file(s) up-to-date.");
        ReconcileFilesOptions statusOpts = new ReconcileFilesOptions();
        statusOpts.setUseWildcards(true);
        statusOpts.setOutsideAdd(true);
        statusOpts.setOutsideEdit(true);
        List status = this.iclient.reconcileFiles(files, statusOpts);
        this.validate.check((List<IFileSpec>)status, "- no file(s) to reconcile", "instead of", "empty, assuming text", "also opened by");
    }

    public void publishChange(Publish publish) throws Exception {
        TimeTask timer = new TimeTask();
        this.log("P4 Task: publish files to Perforce.");
        String ws = "//" + this.iclient.getName() + "/...";
        List files = FileSpecBuilder.makeFileSpecList((String)ws);
        String desc = publish.getExpandedDesc();
        IChangelist change = this.createChangeList(files, desc);
        OpenedFilesOptions openOps = new OpenedFilesOptions();
        List open = this.iclient.openedFiles(files, openOps);
        for (IFileSpec f : open) {
            FileAction action = f.getAction();
            String path = f.getDepotPathString();
            this.log("... ... " + action + " " + path);
        }
        if (publish instanceof SubmitImpl) {
            SubmitImpl submit = (SubmitImpl)publish;
            boolean reopen = submit.isReopen();
            this.submitFiles(change, reopen);
        }
        if (publish instanceof ShelveImpl) {
            ShelveImpl shelve = (ShelveImpl)publish;
            boolean revert = shelve.isRevert();
            this.shelveFiles(change, files, revert);
        }
        this.log("duration: " + timer.toString() + "\n");
    }

    private IChangelist createChangeList(List<IFileSpec> files, String desc) throws Exception {
        Changelist change = new Changelist();
        change.setDescription(desc);
        change = this.iclient.createChangelist((IChangelist)change);
        this.log("... pending change: " + change.getId());
        ReopenFilesOptions reopenOpts = new ReopenFilesOptions();
        reopenOpts.setChangelistId(change.getId());
        this.iclient.reopenFiles(files, reopenOpts);
        return change;
    }

    private void submitFiles(IChangelist change, boolean reopen) throws Exception {
        this.log("... submitting files");
        SubmitOptions submitOpts = new SubmitOptions();
        submitOpts.setReOpen(reopen);
        List submitted = change.submit(submitOpts);
        this.validate.check((List<IFileSpec>)submitted, "Submitted as change");
        long cngNumber = this.findSubmittedChange(submitted);
        if (cngNumber > 0L) {
            this.log("... submitted in change: " + cngNumber);
        }
    }

    private void shelveFiles(IChangelist change, List<IFileSpec> files, boolean revert) throws Exception {
        this.log("... shelving files");
        List shelved = this.iclient.shelveChangelist(change);
        this.validate.check((List<IFileSpec>)shelved, "");
        RevertFilesOptions revertOpts = new RevertFilesOptions();
        revertOpts.setChangelistId(change.getId());
        revertOpts.setNoClientRefresh(!revert);
        String r = revert ? "(revert)" : "(revert -k)";
        this.log("... reverting open files " + r);
        this.iclient.revertFiles(files, revertOpts);
    }

    private long findSubmittedChange(List<IFileSpec> submitted) {
        long change = 0L;
        for (IFileSpec spec : submitted) {
            String cng;
            String msg;
            if (spec.getOpStatus() == FileSpecOpStatus.VALID || !(msg = spec.getStatusMessage()).startsWith(cng = "Submitted as change ")) continue;
            try {
                String id = msg.substring(cng.length());
                change = Long.parseLong(id);
            }
            catch (NumberFormatException e) {
                change = -1L;
            }
        }
        return change;
    }

    private boolean isOpened(List<IFileSpec> files) throws Exception {
        OpenedFilesOptions openOps = new OpenedFilesOptions();
        List open = this.iclient.openedFiles(files, openOps);
        for (IFileSpec file : open) {
            if (file == null || file.getAction() == null) continue;
            return true;
        }
        return false;
    }

    private String depotToLocal(IFileSpec fileSpec) throws Exception {
        String depotPath = fileSpec.getDepotPathString();
        if (depotPath == null) {
            depotPath = fileSpec.getOriginalPathString();
        }
        if (depotPath == null) {
            return null;
        }
        List dSpec = FileSpecBuilder.makeFileSpecList((String)depotPath);
        List lSpec = this.iclient.where(dSpec);
        String path = ((IFileSpec)lSpec.get(0)).getLocalPathString();
        return path;
    }

    private void printFile(String rev) throws Exception {
        int len;
        byte[] buf = new byte[65536];
        List file = FileSpecBuilder.makeFileSpecList((String)rev);
        GetFileContentsOptions printOpts = new GetFileContentsOptions();
        printOpts.setNoHeaderLine(true);
        InputStream ins = this.connection.getFileContents(file, printOpts);
        String localPath = this.depotToLocal((IFileSpec)file.get(0));
        File target = new File(localPath);
        if (target.exists()) {
            target.setWritable(true);
        }
        FileOutputStream outs = new FileOutputStream(target);
        BufferedOutputStream bouts = new BufferedOutputStream(outs);
        while ((len = ins.read(buf)) > 0) {
            bouts.write(buf, 0, len);
        }
        ins.close();
        bouts.close();
    }

    public void unshelveFiles(int review) throws Exception {
        if (review < 1) {
            this.log("P4 Task: skipping review: " + review);
            return;
        }
        TimeTask timer = new TimeTask();
        this.log("P4 Task: unshelve review: " + review);
        List shelveMsg = this.iclient.unshelveChangelist(review, null, 0, true, false);
        this.validate.check((List<IFileSpec>)shelveMsg, false, "also opened by", "no such file(s)", "exclusive file already opened");
        for (IFileSpec spec : shelveMsg) {
            if (spec.getOpStatus() != FileSpecOpStatus.VALID) {
                String msg = spec.getStatusMessage();
                if (!msg.contains("exclusive file already opened")) continue;
                String rev = msg.substring(0, msg.indexOf(" - can't "));
                this.printFile(rev);
                continue;
            }
            this.log(spec.getDepotPathString());
        }
        this.log("... duration: " + timer.toString());
    }

    public void resolveFiles(String mode) throws Exception {
        if ("none".equals(mode)) {
            return;
        }
        TimeTask timer = new TimeTask();
        this.log("P4 Task: resolve: -" + mode);
        String path = this.iclient.getRoot() + "/...";
        List files = FileSpecBuilder.makeFileSpecList((String)path);
        ResolveFilesAutoOptions rsvOpts = new ResolveFilesAutoOptions();
        rsvOpts.setAcceptTheirs("at".equals(mode));
        rsvOpts.setAcceptYours("ay".equals(mode));
        rsvOpts.setSafeMerge("as".equals(mode));
        rsvOpts.setForceResolve("af".equals(mode));
        List rsvMsg = this.iclient.resolveFilesAuto(files, rsvOpts);
        this.validate.check((List<IFileSpec>)rsvMsg, "no file(s) to resolve");
        this.log("... duration: " + timer.toString());
    }

    public int getClientHead() throws Exception {
        String latestChange = this.connection.getCounter("change");
        int change = Integer.parseInt(latestChange);
        String ws = "//" + this.iclient.getName() + "/...";
        List files = FileSpecBuilder.makeFileSpecList((String)ws);
        GetChangelistsOptions opts = new GetChangelistsOptions();
        opts.setType(IChangelist.Type.SUBMITTED);
        opts.setMaxMostRecent(1);
        List list = this.connection.getChangelists(files, opts);
        if (!list.isEmpty() && list.get(0) != null) {
            change = ((IChangelistSummary)list.get(0)).getId();
        } else {
            this.log("P4: no revisions under " + ws + " using latest change: " + change);
        }
        return change;
    }

    public List<Integer> listChanges(P4Revision from, P4Revision to) throws Exception {
        if (from.equals(to)) {
            return new ArrayList<Integer>();
        }
        String ws = "//" + this.iclient.getName() + "/...@" + from + "," + to;
        List<Integer> list = this.listChanges(ws);
        if (!from.isLabel()) {
            Integer obj = from.getChange();
            list.remove(obj);
        }
        return list;
    }

    public List<Integer> listChanges(P4Revision from) throws Exception {
        String ws = "//" + this.iclient.getName() + "/...@" + from + ",now";
        List<Integer> list = this.listChanges(ws);
        if (!from.isLabel()) {
            Integer obj = from.getChange();
            list.remove(obj);
        }
        return list;
    }

    public List<Integer> listChanges() throws Exception {
        String ws = "//" + this.iclient.getName() + "/...";
        return this.listChanges(ws);
    }

    private List<Integer> listChanges(String ws) throws Exception {
        ArrayList<Integer> list = new ArrayList<Integer>();
        List spec = FileSpecBuilder.makeFileSpecList((String)ws);
        GetChangelistsOptions opts = new GetChangelistsOptions();
        opts.setMaxMostRecent(100);
        List cngs = this.connection.getChangelists(spec, opts);
        if (cngs != null) {
            for (IChangelistSummary c : cngs) {
                if (c == null || c.getId() == -1 || list.contains(c.getId())) continue;
                list.add(c.getId());
            }
        }
        return list;
    }

    public List<Integer> listHaveChanges() throws Exception {
        String path = "//" + this.iclient.getName() + "/...";
        return this.listHaveChanges(path);
    }

    public List<Integer> listHaveChanges(P4Revision changeLimit) throws Exception {
        String path = "//" + this.iclient.getName() + "/...";
        String fileSpec = path + "@" + changeLimit;
        return this.listHaveChanges(fileSpec);
    }

    private List<Integer> listHaveChanges(String fileSpec) throws Exception {
        Map[] map;
        ArrayList<Integer> haveChanges = new ArrayList<Integer>();
        for (Map entry : map = this.connection.execMapCmd("cstat", new String[]{fileSpec}, null)) {
            String status = (String)entry.get("status");
            if (status == null || !status.startsWith("have")) continue;
            String value = (String)entry.get("change");
            int change = Integer.parseInt(value);
            haveChanges.add(change);
        }
        return haveChanges;
    }

    public ClientView getClientView() {
        return this.iclient.getClientView();
    }

    public boolean isClientValid(Workspace workspace) {
        if (this.iclient == null) {
            String msg;
            if (workspace instanceof TemplateWorkspaceImpl) {
                TemplateWorkspaceImpl template = (TemplateWorkspaceImpl)workspace;
                String name = template.getTemplateName();
                msg = "P4: Template workspace not found: " + name;
            } else {
                String name = workspace.getFullName();
                msg = "P4: Unable to use workspace: " + name;
            }
            logger.severe(msg);
            if (this.listener != null) {
                this.log(msg);
            }
            return false;
        }
        return true;
    }

    public IClient getClient() {
        return this.iclient;
    }
}

