/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.changes;

import com.perforce.p4java.core.IChangelistSummary;
import java.io.Serializable;
import org.jenkinsci.plugins.p4.changes.P4ChangeEntry;
import org.jenkinsci.plugins.p4.client.ClientHelper;

public class P4Revision
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int change;
    private final String label;
    private final boolean isLabel;

    public P4Revision(String label) {
        this.change = -1;
        this.label = label;
        this.isLabel = true;
    }

    public P4Revision(int change) {
        this.change = change;
        this.label = null;
        this.isLabel = false;
    }

    public boolean isLabel() {
        return this.isLabel;
    }

    public String toString() {
        if (this.isLabel) {
            return this.label;
        }
        return Integer.toString(this.change);
    }

    public int getChange() {
        return this.change;
    }

    public P4ChangeEntry getChangeEntry(ClientHelper p4) throws Exception {
        P4ChangeEntry cl = new P4ChangeEntry();
        if (this.isLabel) {
            cl.setLabel(p4, this.label);
        } else {
            IChangelistSummary summary = p4.getChangeSummary(this.change);
            cl.setChange(p4, summary);
        }
        return cl;
    }

    public boolean equals(Object obj) {
        P4Revision rev;
        return obj instanceof P4Revision && (rev = (P4Revision)obj).toString().equals(this.toString());
    }

    public int hashCode() {
        int hash = 3;
        hash = 89 * hash + this.toString().hashCode();
        return hash;
    }
}

