/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.changes;

import com.perforce.p4java.core.IChangelistSummary;
import com.perforce.p4java.core.IFix;
import com.perforce.p4java.core.file.FileAction;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.impl.generic.core.Fix;
import com.perforce.p4java.impl.generic.core.file.FileSpec;
import hudson.model.AbstractProject;
import hudson.model.Job;
import hudson.model.Run;
import hudson.scm.ChangeLogParser;
import hudson.scm.ChangeLogSet;
import hudson.scm.RepositoryBrowser;
import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jenkinsci.plugins.p4.PerforceScm;
import org.jenkinsci.plugins.p4.changes.P4ChangeEntry;
import org.jenkinsci.plugins.p4.changes.P4ChangeSet;
import org.jenkinsci.plugins.p4.changes.P4Revision;
import org.jenkinsci.plugins.p4.client.ConnectionHelper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class P4ChangeParser
extends ChangeLogParser {
    public ChangeLogSet<? extends ChangeLogSet.Entry> parse(Run run, RepositoryBrowser<?> browser, File file) throws IOException, SAXException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            ChangeLogHandler handler = new ChangeLogHandler(run, browser);
            parser.parse(file, (DefaultHandler)handler);
            P4ChangeSet changeSet = handler.getChangeLogSet();
            return changeSet;
        }
        catch (Exception e) {
            throw new SAXException("Could not parse perforce changelog: ", e);
        }
    }

    public static class ChangeLogHandler
    extends DefaultHandler {
        private Stack<P4ChangeEntry> objects = new Stack();
        private StringBuffer text = new StringBuffer();
        private List<P4ChangeEntry> changeEntries;
        private P4ChangeSet changeSet;
        private Run<?, ?> run;
        private RepositoryBrowser<?> browser;

        public ChangeLogHandler(Run<?, ?> run, RepositoryBrowser<?> browser) {
            this.run = run;
            this.browser = browser;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.text.append(ch, start, length);
        }

        @Override
        public void startDocument() throws SAXException {
            this.changeEntries = new ArrayList<P4ChangeEntry>();
            this.changeSet = new P4ChangeSet(this.run, this.browser, this.changeEntries);
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equalsIgnoreCase("changelog")) {
                this.text.setLength(0);
                return;
            }
            if (qName.equalsIgnoreCase("entry")) {
                this.objects.push(new P4ChangeEntry(this.changeSet));
                this.text.setLength(0);
                return;
            }
            if (this.objects.peek() instanceof P4ChangeEntry) {
                P4ChangeEntry entry = this.objects.peek();
                try {
                    if (qName.equalsIgnoreCase("file")) {
                        FileSpec temp = new FileSpec();
                        String safePath = attributes.getValue("depot");
                        String depotPath = URLDecoder.decode(safePath, "UTF-8");
                        temp.setDepotPath(depotPath);
                        String action = attributes.getValue("action");
                        temp.setAction(FileAction.fromString((String)action));
                        String strRev = attributes.getValue("endRevision");
                        int endRevision = new Integer(strRev);
                        temp.setEndRevision(endRevision);
                        entry.files.add((IFileSpec)temp);
                        this.text.setLength(0);
                        return;
                    }
                    if (qName.equalsIgnoreCase("job")) {
                        Fix temp = new Fix();
                        String id = attributes.getValue("id");
                        temp.setJobId(id);
                        String status = attributes.getValue("status");
                        temp.setStatus(status);
                        entry.jobs.add((IFix)temp);
                        this.text.setLength(0);
                        return;
                    }
                }
                catch (Exception e) {
                    entry = null;
                }
            }
            this.text.setLength(0);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equalsIgnoreCase("changelog")) {
                return;
            }
            if (qName.equalsIgnoreCase("entry")) {
                P4ChangeEntry entry = this.objects.pop();
                this.changeEntries.add(entry);
                return;
            }
            if (this.objects.peek() instanceof P4ChangeEntry) {
                P4ChangeEntry entry = this.objects.peek();
                try {
                    if (this.text.toString().trim().length() != 0 && (qName.equalsIgnoreCase("changenumber") || qName.equalsIgnoreCase("label"))) {
                        Job job = this.run.getParent();
                        AbstractProject project = (AbstractProject)job;
                        PerforceScm scm = (PerforceScm)project.getScm();
                        String credential = scm.getCredential();
                        ConnectionHelper p4 = new ConnectionHelper(credential, null);
                        if (qName.equalsIgnoreCase("changenumber")) {
                            int id = new Integer(this.text.toString());
                            IChangelistSummary summary = p4.getChangeSummary(id);
                            entry.setChange(p4, summary);
                        }
                        if (qName.equalsIgnoreCase("label")) {
                            String id = this.text.toString();
                            entry.setLabel(p4, id);
                        }
                        p4.disconnect();
                    } else {
                        String elementText = this.text.toString().trim();
                        if (qName.equalsIgnoreCase("changeInfo")) {
                            int id = new Integer(elementText);
                            entry.setId(new P4Revision(id));
                            this.text.setLength(0);
                            return;
                        }
                        if (qName.equalsIgnoreCase("shelved")) {
                            entry.setShelved(elementText.equals("true"));
                            this.text.setLength(0);
                        }
                        if (qName.equalsIgnoreCase("msg")) {
                            entry.setMsg(elementText);
                            this.text.setLength(0);
                        }
                        if (qName.equalsIgnoreCase("clientId")) {
                            entry.setClientId(elementText);
                            this.text.setLength(0);
                            return;
                        }
                        if (qName.equalsIgnoreCase("changeUser")) {
                            entry.setAuthor(elementText);
                            this.text.setLength(0);
                            return;
                        }
                        if (qName.equalsIgnoreCase("changeTime")) {
                            entry.setDate(elementText);
                            this.text.setLength(0);
                            return;
                        }
                    }
                    this.text.setLength(0);
                    return;
                }
                catch (Exception e) {
                    entry = null;
                }
            }
        }

        public P4ChangeSet getChangeLogSet() {
            return this.changeSet;
        }
    }
}

