/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.changes;

import com.perforce.p4java.core.ChangelistStatus;
import com.perforce.p4java.core.IChangelistSummary;
import com.perforce.p4java.core.IFix;
import com.perforce.p4java.core.file.FileAction;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.impl.generic.core.Label;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.scm.ChangeLogSet;
import hudson.tasks.Mailer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import org.jenkinsci.plugins.p4.changes.P4ChangeSet;
import org.jenkinsci.plugins.p4.changes.P4Revision;
import org.jenkinsci.plugins.p4.client.ConnectionHelper;
import org.jenkinsci.plugins.p4.email.P4UserProperty;
import org.kohsuke.stapler.export.Exported;

public class P4ChangeEntry
extends ChangeLogSet.Entry {
    private static Logger logger = Logger.getLogger(P4ChangeEntry.class.getName());
    private int FILE_COUNT_LIMIT = 50;
    private P4Revision id;
    private User author;
    private Date date = new Date();
    private String clientId = "";
    private String msg = "";
    private Collection<String> affectedPaths;
    private boolean shelved;
    private boolean fileLimit = false;
    public List<IFileSpec> files;
    public List<IFix> jobs;

    public P4ChangeEntry(P4ChangeSet parent) {
        this.setParent(parent);
        this.files = new ArrayList<IFileSpec>();
        this.jobs = new ArrayList<IFix>();
        this.affectedPaths = new ArrayList<String>();
    }

    public P4ChangeEntry() {
    }

    public void setChange(ConnectionHelper p4, IChangelistSummary changelist) throws Exception {
        int changeId = changelist.getId();
        this.id = new P4Revision(changeId);
        String user = changelist.getUsername();
        this.author = User.get((String)user);
        String email = p4.getEmail(user);
        if (email != null && !email.isEmpty()) {
            P4UserProperty p4prop = new P4UserProperty(email);
            this.author.addProperty((UserProperty)p4prop);
            logger.fine("Setting email for user: " + user + ":" + email);
            Mailer.UserProperty prop = (Mailer.UserProperty)this.author.getProperty(Mailer.UserProperty.class);
            if (prop == null || prop.getAddress() == null || prop.getAddress().isEmpty()) {
                prop = new Mailer.UserProperty(email);
                this.author.addProperty((UserProperty)prop);
                logger.fine("Setting default user: " + user + ":" + email);
            }
        }
        this.date = changelist.getDate();
        this.clientId = changelist.getClientId();
        this.msg = changelist.getDescription();
        if (changelist.getStatus() == ChangelistStatus.PENDING) {
            this.files = p4.getShelvedFiles(changeId);
            this.shelved = true;
        } else {
            this.files = p4.getChangeFiles(changeId);
            this.shelved = false;
        }
        if (this.files.size() > this.FILE_COUNT_LIMIT) {
            this.fileLimit = true;
            this.files = this.files.subList(0, this.FILE_COUNT_LIMIT);
        }
        this.affectedPaths = new ArrayList<String>();
        for (IFileSpec item : this.files) {
            this.affectedPaths.add(item.getDepotPathString());
        }
        this.jobs = p4.getJobs(changeId);
    }

    public void setLabel(ConnectionHelper p4, String labelId) throws Exception {
        Label label = p4.getLabel(labelId);
        this.id = new P4Revision(labelId);
        String user = label.getOwnerName();
        user = user != null && !user.isEmpty() ? user : "unknown";
        this.author = User.get((String)user);
        this.date = label.getLastAccess();
        this.clientId = labelId;
        this.msg = label.getDescription();
        this.files = p4.getLabelFiles(labelId, this.FILE_COUNT_LIMIT + 1);
        if (this.files.size() > this.FILE_COUNT_LIMIT) {
            this.fileLimit = true;
            this.files = this.files.subList(0, this.FILE_COUNT_LIMIT);
        }
        this.affectedPaths = new ArrayList<String>();
        for (IFileSpec item : this.files) {
            this.affectedPaths.add(item.getDepotPathString());
        }
    }

    @Exported
    public String getChangeNumber() {
        return this.id.toString();
    }

    @Exported
    public String getChangeTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(this.date);
    }

    public P4Revision getId() {
        return this.id;
    }

    public void setId(P4Revision value) {
        this.id = value;
    }

    public User getAuthor() {
        if (this.author == null) {
            return User.getUnknown();
        }
        return this.author;
    }

    public void setAuthor(String value) {
        this.author = User.get((String)value);
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(String value) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            this.date = sdf.parse(value);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public void setClientId(String value) {
        this.clientId = value;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String value) {
        this.msg = value;
    }

    public Collection<String> getAffectedPaths() {
        if (this.affectedPaths.size() < 1 && this.files != null && this.files.size() > 0) {
            for (IFileSpec item : this.files) {
                this.affectedPaths.add(item.getDepotPathString());
            }
        }
        return this.affectedPaths;
    }

    public boolean isFileLimit() {
        return this.fileLimit;
    }

    public List<IFileSpec> getFiles() {
        return this.files;
    }

    public String getAction(IFileSpec file) {
        FileAction action = file.getAction();
        String s = action.name();
        return s.replace("/", "_");
    }

    public void setShelved(boolean value) {
        this.shelved = value;
    }

    public boolean isShelved() {
        return this.shelved;
    }

    public boolean isLabel() {
        return this.id.isLabel();
    }

    public List<IFix> getJobs() {
        return this.jobs;
    }

    public String getJobStatus(IFix job) {
        String status = job.getStatus();
        return status;
    }

    public int getMaxLimit() {
        return this.FILE_COUNT_LIMIT;
    }
}

