/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.browsers;

import com.perforce.p4java.core.file.IFileSpec;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.scm.RepositoryBrowser;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.URL;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.p4.browsers.P4Browser;
import org.jenkinsci.plugins.p4.changes.P4ChangeEntry;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class SwarmBrowser
extends P4Browser {
    private static final long serialVersionUID = 1L;
    public final URL url;

    @DataBoundConstructor
    public SwarmBrowser(URL url) {
        this.url = SwarmBrowser.normalizeToEndWithSlash((URL)url);
    }

    public URL getChangeSetLink(P4ChangeEntry changeSet) throws IOException {
        return new URL(this.url.toString() + "change/" + changeSet.getId());
    }

    public URL getLabelSetLink(P4ChangeEntry changeSet) throws IOException {
        return new URL(this.url.toString() + "label/" + changeSet.getId());
    }

    @Override
    public URL getDiffLink(IFileSpec file) throws Exception {
        return null;
    }

    @Override
    public URL getFileLink(IFileSpec file) throws Exception {
        int r = new Integer(file.getEndRevision());
        String path = file.getDepotPathString();
        path = path.replace("//", "files/");
        String rev = "?v=" + r;
        return new URL(this.url.toString() + path + rev);
    }

    @Override
    public URL getJobLink(String job) throws Exception {
        return new URL(this.url.toString() + "jobs/" + job);
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<RepositoryBrowser<?>> {
        public String getDisplayName() {
            return "Swarm browser";
        }

        public FormValidation doCheck(@QueryParameter String value) throws IOException, ServletException {
            String url = Util.fixEmpty((String)value);
            if (url == null) {
                return FormValidation.ok();
            }
            if (!url.startsWith("http://") && !url.startsWith("https://")) {
                return FormValidation.errorWithMarkup((String)"The URL should contain <tt>http://</tt> or <tt>https://</tt>");
            }
            return FormValidation.ok();
        }

        public SwarmBrowser newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (SwarmBrowser)((Object)req.bindParameters(SwarmBrowser.class, "swarm."));
        }
    }
}

