/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.browsers;

import com.perforce.p4java.core.file.FileAction;
import com.perforce.p4java.core.file.IFileSpec;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.scm.RepositoryBrowser;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.URL;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.p4.browsers.P4Browser;
import org.jenkinsci.plugins.p4.changes.P4ChangeEntry;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class P4WebBrowser
extends P4Browser {
    private static final long serialVersionUID = 1L;
    public final URL url;
    public final String p4FileEnd = "?ac=22";
    public final String p4DiffEnd = "?ac=19";
    public final String p4ChangeEnd = "?ac=10";
    public final String p4JobEnd = "?ac=111";
    public final String p4LabelEnd = "?ac=16";

    @DataBoundConstructor
    public P4WebBrowser(URL url) {
        this.url = P4WebBrowser.normalizeToEndWithSlash((URL)url);
    }

    public URL getChangeSetLink(P4ChangeEntry changeSet) throws IOException {
        return new URL(this.url.toString() + changeSet.getId() + "?ac=10");
    }

    public URL getLabelSetLink(P4ChangeEntry changeSet) throws IOException {
        return new URL(this.url.toString() + changeSet.getId() + "?ac=16");
    }

    @Override
    public URL getDiffLink(IFileSpec file) throws Exception {
        if (file.getAction() != FileAction.EDIT && file.getAction() != FileAction.INTEGRATE) {
            return null;
        }
        int r = new Integer(file.getEndRevision());
        if (r <= 1) {
            return null;
        }
        return new URL(this.url.toString() + file.getDepotPathString() + "?ac=19" + "&rev1=" + (r - 1) + "&rev2=" + r);
    }

    @Override
    public URL getFileLink(IFileSpec file) throws Exception {
        return new URL(this.url.toString() + file.getDepotPathString() + "?ac=22");
    }

    @Override
    public URL getJobLink(String job) throws Exception {
        return new URL(this.url.toString() + job + "?ac=111");
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<RepositoryBrowser<?>> {
        public String getDisplayName() {
            return "P4Web browser";
        }

        public FormValidation doCheck(@QueryParameter String value) throws IOException, ServletException {
            String url = Util.fixEmpty((String)value);
            if (url == null) {
                return FormValidation.ok();
            }
            if (!url.startsWith("http://") && !url.startsWith("https://")) {
                return FormValidation.errorWithMarkup((String)"The URL should contain <tt>http://</tt> or <tt>https://</tt>");
            }
            return FormValidation.ok();
        }

        public P4WebBrowser newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (P4WebBrowser)((Object)req.bindParameters(P4WebBrowser.class, "p4web."));
        }
    }
}

