/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.browsers;

import com.perforce.p4java.core.file.IFileSpec;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.scm.RepositoryBrowser;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import org.jenkinsci.plugins.p4.browsers.P4Browser;
import org.jenkinsci.plugins.p4.changes.P4ChangeEntry;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class OpenGrokBrowser
extends P4Browser {
    private static final long serialVersionUID = 1L;
    public final URL url;
    public final String depotPath;
    public final String projectName;

    @DataBoundConstructor
    public OpenGrokBrowser(URL url, String depotPath, String projectName) {
        this.url = OpenGrokBrowser.normalizeToEndWithSlash((URL)url);
        this.depotPath = depotPath;
        this.projectName = projectName;
    }

    @Override
    public URL getDiffLink(IFileSpec file) throws Exception {
        if (file.getEndRevision() <= 1) {
            return null;
        }
        String path = this.getRelativeFilename(file);
        int rev2 = file.getEndRevision();
        int rev1 = file.getEndRevision() - 1;
        String r1 = "r1=" + URLEncoder.encode(path + "#" + rev1, "UTF-8");
        String r2 = "r2=" + URLEncoder.encode(path + "#" + rev2, "UTF-8");
        return new URL(this.url, "source/diff/" + this.projectName + "/build.properties?" + r2 + "&" + r1 + this.getRelativeFilename(file));
    }

    @Override
    public URL getFileLink(IFileSpec file) throws Exception {
        return new URL(this.url, "source/xref/" + this.projectName + "/" + this.getRelativeFilename(file));
    }

    @Override
    public URL getJobLink(String job) throws Exception {
        return null;
    }

    private String getRelativeFilename(IFileSpec file) {
        String path = file.getDepotPathString();
        if (path.startsWith(this.depotPath)) {
            path = path.substring(this.depotPath.length());
        }
        return OpenGrokBrowser.trimHeadSlash((String)path);
    }

    public URL getChangeSetLink(P4ChangeEntry changeSet) throws IOException {
        return null;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<RepositoryBrowser<?>> {
        public String getDisplayName() {
            return "OpenGrok";
        }

        public FormValidation doCheck(@QueryParameter String value) {
            String url = Util.fixEmpty((String)value);
            if (url == null) {
                return FormValidation.ok();
            }
            if (!url.startsWith("http://") && !url.startsWith("https://")) {
                return FormValidation.errorWithMarkup((String)"The URL should contain <tt>http://</tt> or <tt>https://</tt>");
            }
            return FormValidation.ok();
        }
    }
}

