/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.browsers;

import com.perforce.p4java.core.file.FileAction;
import com.perforce.p4java.core.file.IFileSpec;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.scm.RepositoryBrowser;
import hudson.scm.browsers.QueryBuilder;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.URL;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.p4.browsers.P4Browser;
import org.jenkinsci.plugins.p4.browsers.P4WebBrowser;
import org.jenkinsci.plugins.p4.changes.P4ChangeEntry;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class FishEyeBrowser
extends P4Browser {
    private static final long serialVersionUID = 1L;
    public final URL url;
    public final String rootModule;

    @DataBoundConstructor
    public FishEyeBrowser(URL url, String rootModule) {
        this.url = FishEyeBrowser.normalizeToEndWithSlash((URL)url);
        this.rootModule = FishEyeBrowser.trimHeadSlash((String)FishEyeBrowser.trimHeadSlash((String)rootModule));
    }

    public URL getChangeSetLink(P4ChangeEntry changeSet) throws IOException {
        return new URL(this.url, "../../changelog/" + this.getProjectName() + "/?cs=" + changeSet.getId());
    }

    @Override
    public URL getDiffLink(IFileSpec file) throws Exception {
        if (file.getAction() != FileAction.EDIT && file.getAction() != FileAction.INTEGRATE) {
            return null;
        }
        int change = file.getChangelistId();
        if (change <= 1) {
            return null;
        }
        return new URL(this.url, this.getRelativeFilename(file) + new QueryBuilder(this.url.getQuery()).add("r1=").add("r2=" + change));
    }

    @Override
    public URL getFileLink(IFileSpec file) throws Exception {
        return new URL(this.url, this.getRelativeFilename(file) + new QueryBuilder(this.url.getQuery()));
    }

    @Override
    public URL getJobLink(String job) throws Exception {
        return null;
    }

    private String getRelativeFilename(IFileSpec file) {
        String path = FishEyeBrowser.trimHeadSlash((String)FishEyeBrowser.trimHeadSlash((String)file.getDepotPathString()));
        if (path.startsWith(this.getRootModule())) {
            path = path.substring(this.getRootModule().length());
        }
        return FishEyeBrowser.trimHeadSlash((String)path);
    }

    private String getProjectName() {
        String p = this.url.getPath();
        if (p.endsWith("/")) {
            p = p.substring(0, p.length() - 1);
        }
        int idx = p.lastIndexOf(47);
        return p.substring(idx + 1);
    }

    private String getRootModule() {
        if (this.rootModule == null) {
            return "";
        }
        return this.rootModule;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<RepositoryBrowser<?>> {
        private static final Pattern URL_PATTERN = Pattern.compile(".+/browse/[^/]+/");

        public String getDisplayName() {
            return "FishEye browser";
        }

        public FormValidation doCheck(@QueryParameter String value) throws IOException, ServletException {
            String url = Util.fixEmpty((String)value);
            if (url == null) {
                return FormValidation.ok();
            }
            if (!url.endsWith("/")) {
                url = url + '/';
            }
            if (!URL_PATTERN.matcher(url).matches()) {
                return FormValidation.errorWithMarkup((String)"The URL should end like <tt>.../browse/foobar/</tt>");
            }
            return FormValidation.ok();
        }

        public P4WebBrowser newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (P4WebBrowser)((Object)req.bindParameters(P4WebBrowser.class, "fisheye."));
        }
    }
}

