/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4;

import com.perforce.p4java.impl.generic.core.Label;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixExecutionStrategy;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.scm.ChangeLogParser;
import hudson.scm.PollingResult;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.scm.SCMRevisionState;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.p4.browsers.P4Browser;
import org.jenkinsci.plugins.p4.changes.P4ChangeEntry;
import org.jenkinsci.plugins.p4.changes.P4ChangeParser;
import org.jenkinsci.plugins.p4.changes.P4ChangeSet;
import org.jenkinsci.plugins.p4.changes.P4Revision;
import org.jenkinsci.plugins.p4.client.ConnectionHelper;
import org.jenkinsci.plugins.p4.credentials.P4CredentialsImpl;
import org.jenkinsci.plugins.p4.filters.Filter;
import org.jenkinsci.plugins.p4.matrix.MatrixOptions;
import org.jenkinsci.plugins.p4.populate.Populate;
import org.jenkinsci.plugins.p4.review.ReviewProp;
import org.jenkinsci.plugins.p4.tagging.TagAction;
import org.jenkinsci.plugins.p4.tasks.CheckoutTask;
import org.jenkinsci.plugins.p4.tasks.PollTask;
import org.jenkinsci.plugins.p4.tasks.RemoveClientTask;
import org.jenkinsci.plugins.p4.workspace.Workspace;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class PerforceScm
extends SCM {
    private static Logger logger = Logger.getLogger(PerforceScm.class.getName());
    private final String credential;
    private final Workspace workspace;
    private final List<Filter> filter;
    private final Populate populate;
    private final P4Browser browser;
    private transient List<Integer> changes;
    private transient P4Revision parentChange;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    public String getCredential() {
        return this.credential;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public List<Filter> getFilter() {
        return this.filter;
    }

    public Populate getPopulate() {
        return this.populate;
    }

    public P4Browser getBrowser() {
        return this.browser;
    }

    public List<Integer> getChanges() {
        return this.changes;
    }

    @DataBoundConstructor
    public PerforceScm(String credential, Workspace workspace, List<Filter> filter, Populate populate, P4Browser browser) {
        this.credential = credential;
        this.workspace = workspace;
        this.filter = filter;
        this.populate = populate;
        this.browser = browser;
    }

    public PerforceScm(String credential, Workspace workspace, Populate populate) {
        this.credential = credential;
        this.workspace = workspace;
        this.filter = null;
        this.populate = populate;
        this.browser = null;
    }

    public SCMRevisionState calcRevisionsFromBuild(Run<?, ?> run, FilePath buildWorkspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        return SCMRevisionState.NONE;
    }

    public PollingResult compareRemoteRevisionWith(Job<?, ?> job, Launcher launcher, FilePath buildWorkspace, TaskListener listener, SCMRevisionState baseline) throws IOException, InterruptedException {
        PollingResult state = PollingResult.NO_CHANGES;
        Node node = PerforceScm.workspaceToNode(buildWorkspace);
        if (job.isBuilding()) {
            listener.getLogger().println("Build in progress, polling delayed.");
            return PollingResult.NO_CHANGES;
        }
        if (job instanceof MatrixProject) {
            if (this.isBuildParent(job)) {
                EnvVars envVars = job.getEnvironment(node, listener);
                state = this.pollWorkspace(envVars, listener, buildWorkspace);
            } else {
                MatrixProject matrixProj = (MatrixProject)job;
                Collection configs = matrixProj.getActiveConfigurations();
                for (MatrixConfiguration config : configs) {
                    EnvVars envVars = config.getEnvironment(node, listener);
                    state = this.pollWorkspace(envVars, listener, buildWorkspace);
                    if (state != PollingResult.BUILD_NOW) continue;
                    return PollingResult.BUILD_NOW;
                }
            }
        } else {
            EnvVars envVars = job.getEnvironment(node, listener);
            state = this.pollWorkspace(envVars, listener, buildWorkspace);
        }
        return state;
    }

    private PollingResult pollWorkspace(EnvVars envVars, TaskListener listener, FilePath buildWorkspace) throws InterruptedException, IOException {
        PrintStream log = listener.getLogger();
        Node node = PerforceScm.workspaceToNode(buildWorkspace);
        String nodeName = node.getNodeName();
        nodeName = nodeName.isEmpty() ? "master" : nodeName;
        envVars.put("NODE_NAME", envVars.get("NODE_NAME", nodeName));
        Workspace ws = (Workspace)this.workspace.clone();
        ws.setExpand((Map<String, String>)envVars);
        String client = ws.getFullName();
        log.println("P4: Polling on: " + nodeName + " with:" + client);
        String pin = this.populate.getPin();
        if (pin != null && !pin.isEmpty()) {
            pin = ws.getExpand().format(pin, false);
            ws.getExpand().set(ReviewProp.LABEL.toString(), pin);
        }
        PollTask task = new PollTask(this.filter);
        task.setCredential(this.credential);
        task.setWorkspace(ws);
        task.setListener(listener);
        task.setLimit(pin);
        this.changes = (List)buildWorkspace.act((FilePath.FileCallable)task);
        if (!this.changes.isEmpty()) {
            return PollingResult.BUILD_NOW;
        }
        return PollingResult.NO_CHANGES;
    }

    public void checkout(Run<?, ?> run, Launcher launcher, FilePath buildWorkspace, TaskListener listener, File changelogFile, SCMRevisionState baseline) throws IOException, InterruptedException {
        PrintStream log = listener.getLogger();
        boolean success = true;
        CheckoutTask task = new CheckoutTask(this.populate);
        task.setListener(listener);
        task.setCredential(this.credential);
        Workspace ws = task.setEnvironment(run, this.workspace, buildWorkspace);
        ws = task.setNextChange(ws, this.changes);
        this.changes = new ArrayList<Integer>();
        task.setWorkspace(ws);
        task.initialise();
        TagAction tag = new TagAction(run);
        tag.setCredential(this.credential);
        tag.setWorkspace(ws);
        tag.setBuildChange(task.getSyncChange());
        run.addAction((Action)tag);
        String node = ws.getExpand().get("NODE_NAME");
        Job job = run.getParent();
        if (run instanceof MatrixBuild) {
            this.parentChange = task.getSyncChange();
            if (this.isBuildParent(job)) {
                log.println("Building Parent on Node: " + node);
                success &= ((Boolean)buildWorkspace.act((FilePath.FileCallable)task)).booleanValue();
            } else {
                listener.getLogger().println("Skipping Parent build...");
                success = true;
            }
        } else {
            if (job instanceof MatrixProject) {
                if (this.parentChange != null) {
                    log.println("Using parent change: " + this.parentChange);
                    task.setBuildChange(this.parentChange);
                }
                log.println("Building Child on Node: " + node);
            } else {
                log.println("Building on Node: " + node);
            }
            success &= ((Boolean)buildWorkspace.act((FilePath.FileCallable)task)).booleanValue();
        }
        if (success) {
            if (changelogFile != null) {
                listener.getLogger().println("P4 Task: saving built changes.");
                List<P4ChangeEntry> changes = this.calculateChanges(run, task);
                P4ChangeSet.store(changelogFile, changes);
                listener.getLogger().println("... done\n");
            } else {
                listener.getLogger().println("P4 Task: changeLogFile not set. Not saving built changes.");
            }
        } else {
            String msg = "P4: Build failed";
            logger.warning(msg);
            throw new AbortException(msg);
        }
    }

    private MatrixExecutionStrategy getMatrixExecutionStrategy(Job<?, ?> job) {
        if (job instanceof MatrixProject) {
            MatrixProject matrixProj = (MatrixProject)job;
            return matrixProj.getExecutionStrategy();
        }
        return null;
    }

    boolean isBuildParent(Job<?, ?> job) {
        MatrixExecutionStrategy matrix = this.getMatrixExecutionStrategy(job);
        if (matrix instanceof MatrixOptions) {
            return ((MatrixOptions)matrix).isBuildParent();
        }
        return false;
    }

    private List<P4ChangeEntry> calculateChanges(Run<?, ?> run, CheckoutTask task) {
        P4Revision lastRevision;
        P4Revision lastChange;
        TagAction lastTag;
        ArrayList<P4ChangeEntry> list = new ArrayList<P4ChangeEntry>();
        Run lastBuild = run.getPreviousSuccessfulBuild();
        if (lastBuild != null && (lastTag = (TagAction)lastBuild.getAction(TagAction.class)) != null && (lastChange = lastTag.getBuildChange()) != null) {
            List<P4ChangeEntry> changes = task.getChangesFull(lastChange);
            for (P4ChangeEntry c : changes) {
                list.add(c);
            }
        }
        if (list.isEmpty() && (lastRevision = task.getBuildChange()) != null) {
            List<P4ChangeEntry> changes = task.getChangesFull(lastRevision);
            for (P4ChangeEntry c : changes) {
                list.add(c);
            }
        }
        if (lastBuild == null && list.isEmpty()) {
            list.add(task.getCurrentChange());
        }
        return list;
    }

    public void buildEnvVars(AbstractBuild<?, ?> build, Map<String, String> env) {
        super.buildEnvVars(build, env);
        TagAction tagAction = (TagAction)build.getAction(TagAction.class);
        if (tagAction != null) {
            if (tagAction.getBuildChange() != null) {
                String change = this.getChangeNumber(tagAction);
                env.put("P4_CHANGELIST", change);
            }
            if (tagAction.getClient() != null) {
                String client = tagAction.getClient();
                env.put("P4_CLIENT", client);
            }
            if (tagAction.getPort() != null) {
                String port = tagAction.getPort();
                env.put("P4_PORT", port);
            }
            if (tagAction.getUser() != null) {
                String user = tagAction.getUser();
                env.put("P4_USER", user);
            }
            if (tagAction.getTicket() != null) {
                String ticket = tagAction.getTicket();
                env.put("P4_TICKET", ticket);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getChangeNumber(TagAction tagAction) {
        P4Revision buildChange = tagAction.getBuildChange();
        if (!buildChange.isLabel()) {
            return buildChange.toString();
        }
        try {
            int change = Integer.parseInt(buildChange.toString());
            return String.valueOf(change);
        }
        catch (NumberFormatException change) {
            ConnectionHelper p4 = new ConnectionHelper(this.getCredential(), null);
            String name = buildChange.toString();
            try {
                Label label = p4.getLabel(name);
                String spec = label.getRevisionSpec();
                if (spec != null && !spec.isEmpty()) {
                    if (spec.startsWith("@")) {
                        spec = spec.substring(1);
                    }
                    String string = spec;
                    return string;
                }
                String string = name;
                return string;
            }
            catch (Exception e) {
                String string = name;
                return string;
            }
            finally {
                p4.disconnect();
            }
        }
    }

    public ChangeLogParser createChangeLogParser() {
        return new P4ChangeParser();
    }

    public boolean processWorkspaceBeforeDeletion(Job<?, ?> job, FilePath workspace, Node node) throws IOException, InterruptedException {
        logger.info("processWorkspaceBeforeDeletion");
        String scmCredential = this.getCredential();
        Run run = job.getLastBuild();
        if (run == null) {
            logger.warning("P4: No previous builds found");
            return false;
        }
        String client = "unset";
        try {
            EnvVars envVars = run.getEnvironment(null);
            client = (String)envVars.get((Object)"P4_CLIENT");
        }
        catch (Exception e) {
            logger.warning("P4: Unable to read P4_CLIENT");
            return false;
        }
        ConnectionHelper connection = new ConnectionHelper(scmCredential, null);
        try {
            if (!connection.isClient(client)) {
                logger.warning("P4: client not found:" + client);
                return false;
            }
        }
        catch (Exception e) {
            logger.warning("P4: Not able to get connection");
            return false;
        }
        RemoveClientTask task = new RemoveClientTask(scmCredential, client, this.populate);
        boolean clean = (Boolean)workspace.act((FilePath.FileCallable)task);
        logger.info("clean: " + clean);
        return clean;
    }

    public SCMDescriptor<PerforceScm> getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public boolean supportsPolling() {
        return true;
    }

    public boolean requiresWorkspaceForPolling() {
        return true;
    }

    private static Computer workspaceToComputer(FilePath workspace) {
        Jenkins jenkins = Jenkins.getInstance();
        if (workspace.isRemote()) {
            for (Computer computer : jenkins.getComputers()) {
                if (computer.getChannel() != workspace.getChannel()) continue;
                return computer;
            }
        }
        return null;
    }

    private static Node workspaceToNode(FilePath workspace) {
        Computer computer = PerforceScm.workspaceToComputer(workspace);
        if (computer != null) {
            return computer.getNode();
        }
        Jenkins jenkins = Jenkins.getInstance();
        return jenkins;
    }

    @Extension
    public static class DescriptorImpl
    extends SCMDescriptor<PerforceScm> {
        private boolean autov;
        private String credential;
        private String clientName;
        private String depotPath;
        private boolean deleteClient;
        private boolean deleteFiles;

        public boolean isEnabled() {
            return this.autov;
        }

        public String getCredential() {
            return this.credential;
        }

        public String getClientName() {
            return this.clientName;
        }

        public String getDepotPath() {
            return this.depotPath;
        }

        public boolean isDeleteClient() {
            return this.deleteClient;
        }

        public boolean isDeleteFiles() {
            return this.deleteFiles;
        }

        public DescriptorImpl() {
            super(PerforceScm.class, P4Browser.class);
            this.load();
        }

        public SCM newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            PerforceScm scm = (PerforceScm)super.newInstance(req, formData);
            return scm;
        }

        public String getDisplayName() {
            return "Perforce Software";
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.autov = json.getBoolean("autov");
            this.credential = json.getString("credential");
            this.clientName = json.getString("clientName");
            this.depotPath = json.getString("depotPath");
            this.deleteClient = json.getBoolean("deleteClient");
            this.deleteFiles = json.getBoolean("deleteFiles");
            this.save();
            return true;
        }

        public ListBoxModel doFillCredentialItems() {
            return P4CredentialsImpl.doFillCredentialItems();
        }

        public FormValidation doCheckCredential(@QueryParameter String value) {
            return P4CredentialsImpl.doCheckCredential(value);
        }
    }
}

