/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4;

import hudson.Extension;
import hudson.XmlFile;
import hudson.model.Descriptor;
import hudson.model.Saveable;
import hudson.model.TaskListener;
import hudson.model.listeners.SaveableListener;
import hudson.util.LogTaskListener;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.p4.PerforceScm;
import org.jenkinsci.plugins.p4.client.ClientHelper;
import org.jenkinsci.plugins.p4.client.ConnectionHelper;
import org.jenkinsci.plugins.p4.workspace.ManualWorkspaceImpl;
import org.jenkinsci.plugins.p4.workspace.WorkspaceSpec;

@Extension
public class ConfigurationListener
extends SaveableListener {
    private static Logger logger = Logger.getLogger(ConfigurationListener.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChange(Saveable o, XmlFile xml) {
        Descriptor scm = Jenkins.getInstance().getDescriptor(PerforceScm.class);
        PerforceScm.DescriptorImpl p4scm = (PerforceScm.DescriptorImpl)scm;
        if (!p4scm.isEnabled()) {
            return;
        }
        ConnectionHelper p4 = null;
        try {
            String file = xml.getFile().getCanonicalPath();
            logger.info(">>> onUpdated: " + file);
            p4 = this.getClientHelper(p4scm);
            ((ClientHelper)p4).versionFile(file, "Configuration change");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            p4.disconnect();
        }
    }

    private ClientHelper getClientHelper(PerforceScm.DescriptorImpl p4scm) throws Exception {
        LogTaskListener listener = new LogTaskListener(logger, Level.INFO);
        String credential = p4scm.getCredential();
        String clientName = p4scm.getClientName();
        String depotPath = p4scm.getDepotPath();
        depotPath = depotPath.endsWith("/") ? depotPath : depotPath + "/";
        String rootPath = Jenkins.getInstance().getRootDir().getCanonicalPath();
        StringBuffer view = new StringBuffer();
        view.append(depotPath + "...");
        view.append(" ");
        view.append("//" + clientName + "/...");
        WorkspaceSpec spec = new WorkspaceSpec(true, true, false, false, false, false, "", "local", view.toString());
        ManualWorkspaceImpl workspace = new ManualWorkspaceImpl("utf8", false, clientName, spec);
        workspace.setExpand(new HashMap<String, String>());
        workspace.setRootPath(rootPath);
        ClientHelper p4 = new ClientHelper(credential, (TaskListener)listener, clientName, "utf8");
        p4.setClient(workspace);
        return p4;
    }
}

