/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.workspace;

import com.perforce.p4java.client.IClient;
import com.perforce.p4java.client.IClientSummary;
import com.perforce.p4java.impl.mapbased.client.Client;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.IServer;
import hudson.Extension;
import java.io.Serializable;
import java.util.logging.Logger;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.p4.workspace.Workspace;
import org.jenkinsci.plugins.p4.workspace.WorkspaceDescriptor;
import org.jenkinsci.plugins.p4.workspace.WorkspaceType;
import org.kohsuke.stapler.DataBoundConstructor;

public class StreamWorkspaceImpl
extends Workspace
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String streamName;
    private String format;
    private static Logger logger = Logger.getLogger(StreamWorkspaceImpl.class.getName());

    public String getStreamName() {
        return this.streamName;
    }

    public String getFormat() {
        return this.format;
    }

    @Override
    public String getName() {
        return this.format;
    }

    @Override
    public void setName(String name) {
        this.format = name;
    }

    @Override
    public WorkspaceType getType() {
        return WorkspaceType.STREAM;
    }

    @DataBoundConstructor
    public StreamWorkspaceImpl(String charset, boolean pinHost, String streamName, String format) {
        super(charset, pinHost, false);
        this.streamName = streamName;
        this.format = format;
    }

    @Override
    public IClient setClient(IOptionsServer connection, String user) throws Exception {
        String clientName = this.getFullName();
        IClient iclient = connection.getClient(clientName);
        if (iclient == null) {
            logger.info("P4: Creating stream client: " + clientName);
            Client implClient = new Client((IServer)connection);
            implClient.setName(clientName);
            implClient.setOwnerName(user);
            connection.createClient((IClient)implClient);
            iclient = connection.getClient(clientName);
        }
        iclient.setOwnerName(user);
        String streamFullName = this.getExpand().format(this.getStreamName(), true);
        iclient.setStream(streamFullName);
        IClientSummary.IClientOptions options = iclient.getOptions();
        options.setClobber(true);
        iclient.setOptions(options);
        return iclient;
    }

    @Extension
    @Symbol(value={"streamSpec"})
    public static final class DescriptorImpl
    extends WorkspaceDescriptor {
        public String getDisplayName() {
            return "Streams (view generated by Perforce for each node)";
        }
    }
}

