/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.workflow.source;

import hudson.Extension;
import hudson.model.AutoCompletionCandidates;
import hudson.util.FormValidation;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.p4.workflow.source.AbstractSource;
import org.jenkinsci.plugins.p4.workflow.source.P4SyncDescriptor;
import org.jenkinsci.plugins.p4.workspace.StreamWorkspaceImpl;
import org.jenkinsci.plugins.p4.workspace.Workspace;
import org.jenkinsci.plugins.p4.workspace.WorkspaceDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class StreamSource
extends AbstractSource {
    private final String stream;

    @DataBoundConstructor
    public StreamSource(String stream) {
        this.stream = stream;
    }

    public String getStream() {
        return this.stream;
    }

    @Override
    public Workspace getWorkspace(String charset, String format) {
        return new StreamWorkspaceImpl(charset, false, this.stream, format);
    }

    @Extension
    @Symbol(value={"streamSource"})
    public static final class DescriptorImpl
    extends P4SyncDescriptor {
        public String getDisplayName() {
            return "Stream Codeline";
        }

        public AutoCompletionCandidates doAutoCompleteStream(@QueryParameter String value) {
            return WorkspaceDescriptor.doAutoCompleteStreamName(value);
        }

        public FormValidation doCheckStream(@QueryParameter String value) {
            return WorkspaceDescriptor.doCheckStreamName(value);
        }
    }
}

