/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.workflow;

import com.google.common.collect.ImmutableSet;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.Set;
import javax.annotation.Nonnull;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.p4.credentials.P4CredentialsImpl;
import org.jenkinsci.plugins.p4.review.ApproveNotifier;
import org.jenkinsci.plugins.p4.review.ApproveNotifierStep;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class P4ApproveStep
extends Step {
    private final String credential;
    private final String review;
    private final String status;
    private String description;

    public String getCredential() {
        return this.credential;
    }

    public String getReview() {
        return this.review;
    }

    public String getStatus() {
        return this.status;
    }

    public String getDescription() {
        return this.description;
    }

    @DataBoundConstructor
    public P4ApproveStep(String credential, String review, String status) {
        this.credential = credential;
        this.review = review;
        this.status = status;
    }

    @DataBoundSetter
    public void setDescription(String description) {
        this.description = description;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new P4ApproveStepExecution(this, context);
    }

    public static class P4ApproveStepExecution
    extends SynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        private final transient P4ApproveStep step;

        protected P4ApproveStepExecution(P4ApproveStep step, @Nonnull StepContext context) {
            super(context);
            this.step = step;
        }

        protected Void run() throws Exception {
            ApproveNotifierStep notifier = new ApproveNotifierStep(this.step.getCredential(), this.step.getReview(), this.step.getStatus());
            notifier.setDescription(this.step.getDescription());
            notifier.perform((Run)this.getContext().get(Run.class), (FilePath)this.getContext().get(FilePath.class), (Launcher)this.getContext().get(Launcher.class), (TaskListener)this.getContext().get(TaskListener.class));
            return null;
        }
    }

    @Extension(optional=true)
    @Symbol(value={"approve"})
    public static final class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "p4approve";
        }

        public String getDisplayName() {
            return "P4 ApproveImpl Review";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(Run.class, FilePath.class, Launcher.class, TaskListener.class);
        }

        public ListBoxModel doFillCredentialItems(@AncestorInPath Item project, @QueryParameter String credential) {
            return P4CredentialsImpl.doFillCredentialItems(project, credential);
        }

        public FormValidation doCheckCredential(@AncestorInPath Item project, @QueryParameter String value) {
            return P4CredentialsImpl.doCheckCredential(project, value);
        }

        public ListBoxModel doFillStatusItems() {
            return ApproveNotifier.DescriptorImpl.doFillStatusItems();
        }
    }
}

