/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.tasks;

import com.perforce.p4java.core.IRepo;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.impl.generic.core.Changelist;
import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.security.Roles;
import org.jenkinsci.plugins.p4.changes.P4ChangeRef;
import org.jenkinsci.plugins.p4.changes.P4LabelRef;
import org.jenkinsci.plugins.p4.changes.P4Ref;
import org.jenkinsci.plugins.p4.client.ClientHelper;
import org.jenkinsci.plugins.p4.filters.Filter;
import org.jenkinsci.plugins.p4.filters.FilterPathImpl;
import org.jenkinsci.plugins.p4.filters.FilterPatternListImpl;
import org.jenkinsci.plugins.p4.filters.FilterUserImpl;
import org.jenkinsci.plugins.p4.filters.FilterViewMaskImpl;
import org.jenkinsci.plugins.p4.tasks.AbstractTask;
import org.jenkinsci.remoting.RoleChecker;
import org.jenkinsci.remoting.RoleSensitive;

public class PollTask
extends AbstractTask
implements FilePath.FileCallable<List<P4Ref>>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<Filter> filter;
    private final List<P4Ref> lastRefs;
    private String pin;

    public PollTask(String credential, Run<?, ?> run, TaskListener listener, List<Filter> filter, List<P4Ref> lastRefs) {
        super(credential, run, listener);
        this.filter = filter;
        this.lastRefs = lastRefs;
    }

    public List<P4Ref> invoke(File workspace, VirtualChannel channel) throws IOException {
        return (List)this.tryTask();
    }

    @Override
    public Object task(ClientHelper p4) throws Exception {
        List<Object> changes = new ArrayList();
        changes = this.pin != null && !this.pin.isEmpty() ? p4.listHaveChanges(this.lastRefs, new P4LabelRef(this.pin)) : p4.listHaveChanges(this.lastRefs);
        ArrayList<P4ChangeRef> remainder = new ArrayList<P4ChangeRef>();
        for (P4Ref p4Ref : changes) {
            Changelist changelist;
            long change = p4Ref.getChange();
            if (change <= 0L || this.filterChange(changelist = p4.getChange(change), this.filter)) continue;
            remainder.add(new P4ChangeRef(changelist.getId()));
            p4.log("... found change: " + changelist.getId());
        }
        changes = remainder;
        if (p4.checkVersion(20171)) {
            List<IRepo> repos = p4.listRepos();
            for (IRepo repo : repos) {
                P4Ref graphHead = p4.getGraphHead(repo.getName());
                List<P4Ref> commits = p4.listCommits(this.lastRefs, graphHead);
                changes.addAll(commits);
                for (P4Ref commit : commits) {
                    p4.log("... found commit: " + commit.toString());
                }
            }
        }
        return changes;
    }

    public void setLimit(String expandedPin) {
        this.pin = expandedPin;
    }

    private boolean filterChange(Changelist changelist, List<Filter> scmFilter) throws Exception {
        if (scmFilter == null) {
            return false;
        }
        String user = changelist.getUsername();
        ArrayList<IFileSpec> files = changelist.getFiles(true);
        for (Filter f : scmFilter) {
            String u;
            if (f instanceof FilterUserImpl && (u = ((FilterUserImpl)f).getUser()).equalsIgnoreCase(user)) {
                return true;
            }
            if (f instanceof FilterPathImpl) {
                ArrayList<IFileSpec> remainder = new ArrayList<IFileSpec>();
                String path = ((FilterPathImpl)f).getPath();
                for (IFileSpec s : files) {
                    String p = s.getDepotPathString();
                    if (p.startsWith(path)) continue;
                    remainder.add(s);
                }
                files = remainder;
                if (files.isEmpty()) {
                    return true;
                }
            }
            if (f instanceof FilterViewMaskImpl) {
                ArrayList<IFileSpec> included = new ArrayList<IFileSpec>();
                String viewMask = ((FilterViewMaskImpl)f).getViewMask();
                for (IFileSpec s : files) {
                    boolean isFileInViewMask = false;
                    String p = s.getDepotPathString();
                    for (String maskPath : viewMask.split("\n")) {
                        String excludedMaskPath;
                        if (p.startsWith(maskPath)) {
                            isFileInViewMask = true;
                        }
                        if (!maskPath.startsWith("-") || !p.startsWith(excludedMaskPath = maskPath.substring(maskPath.indexOf("-") + 1))) continue;
                        isFileInViewMask = false;
                    }
                    if (!isFileInViewMask) continue;
                    included.add(s);
                }
                if (included.isEmpty()) {
                    return true;
                }
            }
            if (!(f instanceof FilterPatternListImpl)) continue;
            ArrayList<Pattern> patterns = ((FilterPatternListImpl)f).getPatternList();
            boolean foundMatchingChange = false;
            for (IFileSpec s : files) {
                String p = s.getDepotPathString();
                for (Pattern pattern : patterns) {
                    Matcher matcher = pattern.matcher(p);
                    if (!matcher.matches()) continue;
                    foundMatchingChange = true;
                    break;
                }
                if (!foundMatchingChange) continue;
                break;
            }
            return !foundMatchingChange;
        }
        return false;
    }

    public void checkRoles(RoleChecker checker) throws SecurityException {
        checker.check((RoleSensitive)this, Roles.SLAVE);
    }
}

