/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.tagging;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.util.Map;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.p4.tagging.TagAction;
import org.jenkinsci.plugins.p4.workspace.Expand;
import org.kohsuke.stapler.DataBoundConstructor;

public class TagNotifier
extends Notifier {
    private static final Logger logger = Logger.getLogger(TagNotifier.class.getName());
    public final String rawLabelName;
    public final String rawLabelDesc;
    public final boolean onlyOnSuccess;

    @DataBoundConstructor
    public TagNotifier(String rawLabelName, String rawLabelDesc, boolean onlyOnSuccess) {
        this.rawLabelName = rawLabelName;
        this.rawLabelDesc = rawLabelDesc;
        this.onlyOnSuccess = onlyOnSuccess;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException {
        if (this.onlyOnSuccess && build.getResult() != Result.SUCCESS) {
            return true;
        }
        try {
            EnvVars env = build.getEnvironment((TaskListener)listener);
            Expand expand = new Expand((Map<String, String>)env);
            String name = expand.format(this.rawLabelName, false);
            String description = expand.format(this.rawLabelDesc, false);
            TagAction tagAction = this.getTagAction(env, build);
            FilePath workspace = build.getWorkspace();
            tagAction.labelBuild((TaskListener)listener, name, description, workspace);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    private TagAction getTagAction(EnvVars env, AbstractBuild<?, ?> build) {
        TagAction tagAction = TagAction.getLastAction(build);
        if (tagAction == null) {
            String jobName = (String)env.get((Object)"PROMOTED_JOB_NAME");
            if (jobName == null || jobName.isEmpty()) {
                logger.warning("No tag information; not a promotion job.");
                return tagAction;
            }
            String buildNumber = (String)env.get((Object)"PROMOTED_NUMBER");
            if (buildNumber == null || buildNumber.isEmpty()) {
                logger.warning("No tag information; not a promotion job.");
                return tagAction;
            }
            Jenkins j = Jenkins.getInstance();
            AbstractProject project = (AbstractProject)j.getItemByFullName(jobName, AbstractProject.class);
            if (project == null) {
                logger.warning("No project; is it a valid Perforce job?");
                return tagAction;
            }
            int buildNum = Integer.parseInt(buildNumber);
            build = project.getBuildByNumber(buildNum);
            if (build == null) {
                logger.warning("No build number; is it a valid Perforce job?");
                return tagAction;
            }
            tagAction = (TagAction)build.getAction(TagAction.class);
            if (tagAction == null) {
                logger.warning("No tag information; is it a valid Perforce job?");
                return tagAction;
            }
        }
        return tagAction;
    }

    public static DescriptorImpl descriptor() {
        Jenkins j = Jenkins.getInstance();
        return (DescriptorImpl)j.getDescriptorByType(DescriptorImpl.class);
    }

    @Extension
    @Symbol(value={"label"})
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Perforce: Label build";
        }
    }
}

