/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.swarmAPI;

import java.util.List;
import org.jenkinsci.plugins.p4.scm.P4Path;

public class SwarmProjectAPI {
    private Project project;

    public SwarmProjectAPI() {
    }

    public SwarmProjectAPI(Project project) {
        this.project = project;
    }

    public Project getProject() {
        return this.project;
    }

    public static class Branch {
        private String id;
        private String name;
        private List<String> paths;

        public Branch(String id, String name, List<String> paths) {
            this.id = id;
            this.name = name;
            this.paths = paths;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public P4Path getPath() {
            String path = this.paths.get(0);
            path = path.substring(0, path.lastIndexOf("/..."));
            P4Path p4Path = new P4Path(path);
            p4Path.setMappings(this.paths);
            return p4Path;
        }

        public List<String> getPaths() {
            return this.paths;
        }
    }

    public static class Project {
        private String id;
        private List<String> members;
        private List<String> owners;
        private List<Branch> branches;

        public Project(String id, List<String> members, List<String> owners, List<Branch> branches) {
            this.id = id;
            this.members = members;
            this.owners = owners;
            this.branches = branches;
        }

        public String getId() {
            return this.id;
        }

        public List<String> getMembers() {
            return this.members;
        }

        public List<String> getOwners() {
            return this.owners;
        }

        public List<Branch> getBranches() {
            return this.branches;
        }
    }
}

