/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.scm;

import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.Items;
import java.util.ArrayList;
import java.util.Objects;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import org.jenkinsci.plugins.p4.changes.P4Ref;
import org.jenkinsci.plugins.p4.scm.P4ChangeRequestSCMHead;
import org.jenkinsci.plugins.p4.scm.P4Path;
import org.jenkinsci.plugins.p4.scm.P4SCMHead;

public class P4SCMRevision
extends SCMRevision {
    private final P4Ref ref;

    @Initializer(before=InitMilestone.PLUGINS_STARTED)
    public static void addAliases() {
        Items.XSTREAM2.addCompatibilityAlias("org.jenkinsci.plugins.p4.scm.P4Revision", P4SCMRevision.class);
    }

    public P4SCMRevision(P4SCMHead branch, P4Ref ref) {
        super((SCMHead)branch);
        this.ref = ref;
    }

    public static P4SCMRevision builder(String path, String branch, P4Ref ref) {
        P4Path p4path = new P4Path(path);
        p4path.setRevision(ref.toString());
        P4SCMHead head = new P4SCMHead(branch, p4path);
        return new P4SCMRevision(head, ref);
    }

    public static P4SCMRevision swarmBuilder(String path, String branch, P4Ref ref) {
        ArrayList<String> mappings = new ArrayList<String>();
        mappings.add(path + "/...");
        P4Path p4Path = new P4Path(path);
        p4Path.setRevision(ref.toString());
        p4Path.setMappings(mappings);
        P4SCMHead head = new P4SCMHead(branch, p4Path);
        return new P4SCMRevision(head, ref);
    }

    public static P4SCMRevision swarmBuilder(String path, String branch, P4Ref ref, String reviewID) {
        ArrayList<String> mappings = new ArrayList<String>();
        mappings.add(path + "/...");
        P4Path p4Path = new P4Path(path);
        p4Path.setRevision(reviewID);
        p4Path.setMappings(mappings);
        String trgName = reviewID;
        P4SCMHead target = new P4SCMHead(trgName, p4Path);
        P4ChangeRequestSCMHead head = new P4ChangeRequestSCMHead(trgName, reviewID, p4Path, target);
        return new P4SCMRevision(head, ref);
    }

    public P4Ref getRef() {
        return this.ref;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        P4SCMRevision that = (P4SCMRevision)((Object)o);
        boolean c = this.ref.equals(that.ref);
        boolean h = this.getHead().equals((Object)that.getHead());
        return c && h;
    }

    public int hashCode() {
        return Objects.hashCode(this.ref);
    }

    public String toString() {
        if (this.ref == null) {
            return "undefined";
        }
        return this.ref.toString();
    }
}

