/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.scm;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.scm.SCM;
import hudson.util.LogTaskListener;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.scm.api.SCMFile;
import jenkins.scm.api.SCMFileSystem;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import org.jenkinsci.plugins.p4.PerforceScm;
import org.jenkinsci.plugins.p4.client.TempClientHelper;
import org.jenkinsci.plugins.p4.scm.AbstractP4ScmSource;
import org.jenkinsci.plugins.p4.scm.P4SCMFile;
import org.jenkinsci.plugins.p4.scm.P4SCMRevision;
import org.jenkinsci.plugins.p4.workspace.Workspace;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

public class P4SCMFileSystem
extends SCMFileSystem {
    private static Logger logger = Logger.getLogger(P4SCMFileSystem.class.getName());
    private TempClientHelper p4;

    protected P4SCMFileSystem(@NonNull Item owner, @NonNull PerforceScm scm, @CheckForNull P4SCMRevision rev) throws Exception {
        super((SCMRevision)rev);
        String credential = scm.getCredential();
        Workspace ws = scm.getWorkspace().deepClone();
        if (owner instanceof WorkflowJob) {
            WorkflowJob _job = (WorkflowJob)owner;
            WorkflowRun build = _job.getLastBuild();
            EnvVars env = build.getEnvironment((TaskListener)new LogTaskListener(logger, Level.INFO));
            ws.setExpand((Map<String, String>)env);
        }
        this.p4 = new TempClientHelper(owner, credential, null, ws);
    }

    public void close() throws IOException {
        this.p4.close();
    }

    public long lastModified() throws IOException, InterruptedException {
        return 0L;
    }

    public SCMFile getRoot() {
        return new P4SCMFile(this);
    }

    public TempClientHelper getConnection() {
        return this.p4;
    }

    @Extension
    public static class BuilderImpl
    extends SCMFileSystem.Builder {
        public boolean supports(SCM source) {
            return source instanceof PerforceScm;
        }

        public boolean supports(SCMSource source) {
            return source instanceof AbstractP4ScmSource;
        }

        public SCMFileSystem build(@NonNull Item owner, SCM scm, @CheckForNull SCMRevision rev) throws IOException, InterruptedException {
            if (scm == null || !(scm instanceof PerforceScm)) {
                return null;
            }
            PerforceScm p4scm = (PerforceScm)scm;
            if (rev != null && !(rev instanceof P4SCMRevision)) {
                return null;
            }
            P4SCMRevision p4rev = (P4SCMRevision)rev;
            try {
                return new P4SCMFileSystem(owner, p4scm, p4rev);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }
}

