/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.scm;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.logging.Logger;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.trait.SCMBuilder;
import org.jenkinsci.plugins.p4.PerforceScm;
import org.jenkinsci.plugins.p4.changes.P4Ref;
import org.jenkinsci.plugins.p4.changes.P4RefBuilder;
import org.jenkinsci.plugins.p4.review.P4Review;
import org.jenkinsci.plugins.p4.scm.AbstractP4ScmSource;
import org.jenkinsci.plugins.p4.scm.P4ChangeRequestSCMHead;
import org.jenkinsci.plugins.p4.scm.P4Path;
import org.jenkinsci.plugins.p4.scm.P4SCMHead;
import org.jenkinsci.plugins.p4.tasks.CheckoutStatus;

public class P4SCMBuilder
extends SCMBuilder<P4SCMBuilder, PerforceScm> {
    private static Logger logger = Logger.getLogger(P4SCMBuilder.class.getName());
    private final AbstractP4ScmSource source;
    private final P4SCMHead p4head;
    private final P4Path path;
    private final P4Ref revision;

    public P4SCMBuilder(@NonNull AbstractP4ScmSource source, @NonNull SCMHead head, @CheckForNull SCMRevision revision) {
        super(PerforceScm.class, head, revision);
        this.source = source;
        if (head instanceof P4SCMHead) {
            this.p4head = (P4SCMHead)head;
            this.path = this.p4head.getPath() != null ? this.p4head.getPath() : null;
        } else {
            this.path = null;
            this.p4head = null;
        }
        if (this.path != null && this.path.getRevision() != null) {
            String rev = this.path.getRevision();
            this.revision = P4RefBuilder.get(rev);
        } else {
            this.revision = null;
        }
    }

    @NonNull
    public PerforceScm build() {
        PerforceScm scm = this.p4head.getScm(this.source, this.path, this.revision);
        if (this.p4head instanceof P4ChangeRequestSCMHead && this.revision != null) {
            P4Review review = new P4Review(this.revision.toString(), CheckoutStatus.SHELVED);
            scm.setReview(review);
        }
        logger.fine("SCM: build: " + this.path + " head: " + (Object)((Object)this.p4head) + " rev: " + this.revision);
        return scm;
    }
}

