/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.scm;

import com.perforce.p4java.core.file.IFileSpec;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.TaskListener;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.p4.browsers.P4Browser;
import org.jenkinsci.plugins.p4.client.ConnectionHelper;
import org.jenkinsci.plugins.p4.client.ViewMapHelper;
import org.jenkinsci.plugins.p4.scm.AbstractP4ScmSource;
import org.jenkinsci.plugins.p4.scm.P4Path;
import org.jenkinsci.plugins.p4.scm.P4SCMHead;
import org.jenkinsci.plugins.p4.scm.P4SCMSourceDescriptor;
import org.jenkinsci.plugins.p4.workspace.ManualWorkspaceImpl;
import org.jenkinsci.plugins.p4.workspace.Workspace;
import org.jenkinsci.plugins.p4.workspace.WorkspaceSpec;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class BranchesScmSource
extends AbstractP4ScmSource {
    private P4Browser browser;
    private String pattern = ".*";
    private String mappings = "...";

    @DataBoundConstructor
    public BranchesScmSource(String credential, String includes, String charset, String format) {
        super(credential);
        this.setIncludes(includes);
        this.setCharset(charset);
        this.setFormat(format);
    }

    @DataBoundSetter
    public void setBrowser(P4Browser browser) {
        this.browser = browser;
    }

    @DataBoundSetter
    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getMappings() {
        if (this.mappings == null) {
            this.mappings = "...";
        }
        return this.mappings;
    }

    @DataBoundSetter
    public void setMappings(String mappings) {
        this.mappings = mappings;
    }

    @Override
    public P4Browser getBrowser() {
        return this.browser;
    }

    @Override
    public List<P4SCMHead> getTags(@NonNull TaskListener listener) throws Exception {
        return new ArrayList<P4SCMHead>();
    }

    @Override
    public List<P4SCMHead> getHeads(@NonNull TaskListener listener) throws Exception {
        List<String> paths = this.getIncludePaths();
        ArrayList<P4SCMHead> list = new ArrayList<P4SCMHead>();
        try (ConnectionHelper p4 = new ConnectionHelper((Item)this.getOwner(), this.getCredential(), listener);){
            String actualPattern = this.getPattern();
            if (this.getPattern() == null || this.getPattern().trim().equals("")) {
                actualPattern = ".*";
            }
            Pattern filterPattern = Pattern.compile(actualPattern);
            List<IFileSpec> specs = p4.getDirs(paths);
            for (IFileSpec s : specs) {
                String file;
                String branch = s.getOriginalPathString();
                if (branch == null || branch.isEmpty() || !filterPattern.matcher(branch).matches() || (file = branch.substring(branch.lastIndexOf("/") + 1)) == null || file.isEmpty()) continue;
                P4Path p4Path = new P4Path(branch);
                p4Path.setMappings(this.getDepotPathMappings(p4Path));
                p4Path.setMappings(this.getLocalPathMappings(p4Path));
                P4SCMHead head = new P4SCMHead(file, p4Path);
                list.add(head);
            }
        }
        return list;
    }

    @Override
    public Workspace getWorkspace(P4Path path) {
        if (path == null) {
            throw new IllegalArgumentException("missing branch path");
        }
        List<String> externalViews = this.getDepotPathMappings(path);
        List<String> localViews = this.getLocalPathMappings(path);
        boolean external = false;
        if (externalViews.size() + localViews.size() > 1) {
            external = true;
        }
        StringBuffer view = new StringBuffer();
        String client = this.getFormat();
        String jenkinsView = ViewMapHelper.getScriptView(path.getPath(), this.getScriptPathOrDefault(), client);
        view.append(jenkinsView == null ? "" : jenkinsView + "\n");
        String externalMappings = ViewMapHelper.getClientView(externalViews, client, external, true);
        view.append(externalMappings == null ? "" : externalMappings + "\n");
        String localMappings = ViewMapHelper.getClientView(localViews, client, false, true);
        view.append(localMappings == null ? "" : localMappings + "\n");
        WorkspaceSpec spec = new WorkspaceSpec(view.toString(), null);
        ManualWorkspaceImpl ws = new ManualWorkspaceImpl(this.getCharset(), false, client, spec, false);
        return ws;
    }

    private List<String> getViewMappings() {
        return this.toLines(this.getMappings());
    }

    private List<String> getDepotPathMappings(P4Path path) {
        ArrayList<String> views = new ArrayList<String>();
        for (String mapping : this.getViewMappings()) {
            if (!mapping.startsWith("//")) continue;
            mapping = mapping.replaceAll("\\$\\{BRANCH_NAME\\}", path.getNode());
            views.add(mapping);
        }
        return views;
    }

    private List<String> getLocalPathMappings(P4Path path) {
        ArrayList<String> views = new ArrayList<String>();
        for (String mapping : this.getViewMappings()) {
            if (mapping.startsWith("//")) continue;
            StringBuffer sb = new StringBuffer();
            sb.append(path.getPath());
            sb.append("/");
            sb.append(mapping);
            views.add(sb.toString());
        }
        return views;
    }

    @Extension
    @Symbol(value={"multiBranch"})
    public static final class DescriptorImpl
    extends P4SCMSourceDescriptor {
        public static final String defaultPath = "...";
        public static final String defaultPattern = ".*";

        public String getDisplayName() {
            return "Helix Branches";
        }
    }
}

