/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.review;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.EnvironmentContributor;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class SafeParametersAction
extends ParametersAction {
    private List<ParameterValue> internalParameters;

    public SafeParametersAction(@NonNull List<ParameterValue> params, @NonNull List<ParameterValue> internalParameters) {
        super(params);
        this.internalParameters = internalParameters;
    }

    public List<ParameterValue> getParameters() {
        ArrayList<ParameterValue> params = new ArrayList<ParameterValue>();
        List p = super.getParameters();
        params.addAll(p);
        params.addAll(this.internalParameters);
        return Collections.unmodifiableList(params);
    }

    public ParameterValue getParameter(String name) {
        ParameterValue param = super.getParameter(name);
        if (param != null) {
            return param;
        }
        for (ParameterValue p : this.internalParameters) {
            if (p == null || !p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    List<ParameterValue> getInternalParameters() {
        return Collections.unmodifiableList(this.internalParameters);
    }

    @Extension
    public static final class SafeParametersActionEnvironmentContributor
    extends EnvironmentContributor {
        public void buildEnvironmentFor(Run r, EnvVars envs, TaskListener listener) throws IOException, InterruptedException {
            SafeParametersAction action = (SafeParametersAction)r.getAction(SafeParametersAction.class);
            if (action != null) {
                for (ParameterValue pv : action.getInternalParameters()) {
                    envs.put(pv.getName(), String.valueOf(pv.getValue()));
                }
            }
        }
    }
}

