/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.review;

import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.Queue;
import hudson.model.StringParameterDefinition;
import hudson.model.StringParameterValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import jenkins.util.TimeDuration;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.p4.review.ReviewProp;
import org.jenkinsci.plugins.p4.review.SafeParametersAction;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.verb.POST;

public class ReviewAction<T extends Job<?, ?>>
implements Action {
    private final T project;

    public ReviewAction(T project) {
        this.project = project;
    }

    public T getProject() {
        return this.project;
    }

    public String getIconFileName() {
        return "/plugin/p4/icons/swarm-24px.png";
    }

    public String getDisplayName() {
        return "Build Review";
    }

    public String getUrlName() {
        return "review";
    }

    public List<StringParameterValue> getAvailableParameters() {
        ArrayList<StringParameterValue> stringParameters = new ArrayList<StringParameterValue>();
        for (ParameterDefinition parameterDefinition : this.getParameterDefinitions()) {
            StringParameterValue stringParameter = new StringParameterValue(parameterDefinition.getName(), parameterDefinition.getDescription());
            stringParameters.add(stringParameter);
        }
        return stringParameters;
    }

    @POST
    public void doBuildSubmit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.project.checkPermission(Item.BUILD);
        JSONObject formData = req.getSubmittedForm();
        if (!formData.isEmpty()) {
            this.doBuild(req, rsp);
        }
    }

    @POST
    public void doBuild(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.project.checkPermission(Item.BUILD);
        ArrayList<ParameterValue> values = new ArrayList<ParameterValue>();
        ArrayList<StringParameterDefinition> defs = new ArrayList<StringParameterDefinition>();
        Enumeration names = req.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            defs.add(new StringParameterDefinition(name, null));
        }
        for (ParameterDefinition parameterDefinition : defs) {
            String s;
            StringParameterValue value = (StringParameterValue)parameterDefinition.createValue(req);
            if (value == null || value.getValue() == null || (s = (String)value.getValue()) == null || s.isEmpty()) continue;
            values.add((ParameterValue)value);
        }
        TimeDuration delay = new TimeDuration((long)((ParameterizedJobMixIn.ParameterizedJob)this.project).getQuietPeriod());
        CauseAction causeAction = new CauseAction((Cause)new Cause.UserIdCause());
        List<ParameterValue> internalParams = this.extractAndRemoveInternalParameters(values);
        SafeParametersAction params = new SafeParametersAction(values, internalParams);
        Jenkins j = Jenkins.getInstance();
        Queue queue = j.getQueue();
        queue.schedule((Queue.Task)this.project, delay.getTimeInSeconds(), new Action[]{params, causeAction});
        rsp.sendRedirect("../");
    }

    private List<ParameterValue> extractAndRemoveInternalParameters(List<ParameterValue> values) {
        ArrayList<ParameterValue> internal = new ArrayList<ParameterValue>();
        List<ParameterDefinition> parameterDefinitions = this.getParameterDefinitions();
        Iterator<ParameterValue> it = values.iterator();
        block0: while (it.hasNext()) {
            ParameterValue next = it.next();
            for (ParameterDefinition pd : parameterDefinitions) {
                if (!next.getName().equals(pd.getName())) continue;
                internal.add(next);
                it.remove();
                continue block0;
            }
        }
        return internal;
    }

    private List<ParameterDefinition> getParameterDefinitions() {
        ArrayList<ParameterDefinition> swarm = new ArrayList<ParameterDefinition>();
        swarm.add((ParameterDefinition)new StringParameterDefinition(ReviewProp.SWARM_REVIEW.getProp(), null));
        swarm.add((ParameterDefinition)new StringParameterDefinition(ReviewProp.P4_CHANGE.getProp(), null));
        swarm.add((ParameterDefinition)new StringParameterDefinition(ReviewProp.SWARM_STATUS.getProp(), null));
        swarm.add((ParameterDefinition)new StringParameterDefinition(ReviewProp.SWARM_PASS.getProp(), null));
        swarm.add((ParameterDefinition)new StringParameterDefinition(ReviewProp.SWARM_FAIL.getProp(), null));
        swarm.add((ParameterDefinition)new StringParameterDefinition(ReviewProp.P4_LABEL.toString(), null));
        return swarm;
    }
}

