/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.review;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.EnvironmentContributor;
import hudson.model.Item;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.p4.client.ConnectionHelper;
import org.jenkinsci.plugins.p4.credentials.P4CredentialsImpl;
import org.jenkinsci.plugins.p4.review.ApproveState;
import org.jenkinsci.plugins.p4.swarmAPI.SwarmHelper;
import org.jenkinsci.plugins.p4.workspace.Expand;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class ApproveNotifier
extends Notifier {
    private static Logger logger = Logger.getLogger(ApproveNotifier.class.getName());
    private final String credential;
    private final String review;
    private final String status;
    private String description;

    public String getCredential() {
        return this.credential;
    }

    public String getReview() {
        return this.review;
    }

    public String getStatus() {
        return this.status;
    }

    public String getDescription() {
        return this.description;
    }

    @DataBoundConstructor
    public ApproveNotifier(String credential, String review, String status) {
        this.credential = credential;
        this.review = review;
        this.status = status;
    }

    @DataBoundSetter
    public void setDescription(String description) {
        this.description = description;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        AbstractProject job = (AbstractProject)build.getParent();
        Node node = build.getBuiltOn();
        EnvVars env = job.getEnvironment(node, (TaskListener)listener);
        for (EnvironmentContributor ec : EnvironmentContributor.all().reverseView()) {
            ec.buildEnvironmentFor(build, env, (TaskListener)listener);
        }
        ConnectionHelper p4 = new ConnectionHelper((Item)job, this.getCredential(), (TaskListener)listener);
        try {
            return this.approveReview(p4, env);
        }
        catch (Exception e) {
            throw new InterruptedException("Unable to update Review.");
        }
    }

    protected boolean approveReview(ConnectionHelper p4, EnvVars env) throws Exception {
        SwarmHelper swarm = new SwarmHelper(p4, "4");
        ApproveState state = ApproveState.parse(this.getStatus());
        if (state == null) {
            p4.log("Unknown Swarm review state: " + this.getStatus());
            return false;
        }
        Expand expand = new Expand((Map<String, String>)env);
        String rev = this.getReview();
        rev = expand.format(rev, false);
        String desc = this.getDescription();
        if (desc != null && !desc.isEmpty()) {
            desc = expand.format(desc, false);
        }
        return swarm.approveReview(rev, state, desc);
    }

    public static DescriptorImpl descriptor() {
        Jenkins j = Jenkins.getInstance();
        if (j != null) {
            j.getDescriptorByType(DescriptorImpl.class);
        }
        return null;
    }

    @Extension
    @Symbol(value={"approve"})
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Perforce: ApproveImpl review";
        }

        public ListBoxModel doFillCredentialItems(@AncestorInPath Item project, @QueryParameter String credential) {
            return P4CredentialsImpl.doFillCredentialItems(project, credential);
        }

        public static ListBoxModel doFillStatusItems() {
            ListBoxModel listBoxModel = new ListBoxModel();
            for (ApproveState s : ApproveState.values()) {
                listBoxModel.add(s.getDescription(), s.name());
            }
            return listBoxModel;
        }
    }
}

